
# Optimizing Unknown Objective Functions with Deep Gradient Learning

## Description

Traditional gradient-based optimization techniques require the gradient of the objective function, which is not always available. This project addresses optimization problems where the objective function is unknown and can only be estimated from noisy observations. The code provides solutions for gradient estimation of unknown objective functions in both large-data (ETD) and scarce-data regimes (DGX).

## Package Requirements

The necessary packages and their respective versions required to run this project are summarized in the `requirement.txt` file. Please refer to this file to ensure all dependencies are correctly installed to achieve optimal performance and functionality.

## Code Usage

The simulation problem experiments can be reproduced by running the `main.py` file with the following command lines, specifying the type of dataset and the method used.

Example command lines for running ETD and DGX-full on the NN Small dataset:

### Running ETD:
\`\`\`sh
nohup python3 ./main.py 'nn' './nn100_size128' --DE 1 --gen_data 1 --dim_theta 3 --dim_x 3 --batch_size_e 32 --learning_rate 5e-4 --MC 1 --device 'cuda:0' --size_dataset 128 --num_datasets 1 --num_per_dataset 1 --steps 1000 --noise_ratio 2 --save_freq 10 &
\`\`\`

### Running DGX-full:
\`\`\`sh
nohup python3 ./main.py 'nn' './nn100_size128' --dim_theta 3 --dim_x 3 --integral_step 512 --batch_size_e 32 --batch_size_r 32 --restriction_weight 10 --learning_rate 5e-4 --MC 1 --device 'cuda:0' --size_dataset 128 --num_datasets 1 --num_per_dataset 1 --steps 1000 --num_path 64 --path_sample 1 --noise_ratio 2 --save_freq 10 &
\`\`\`

To reproduce the real-world application experiments, please generate data by following the instructions provided on the OptSim testbed (link given in the paper). Place the generated datasets into a directory named `datasets`. Then, specify the name of the dataset and the dimensions of the data in the command line to execute the code.

## Visualization

All experiment results will be saved in a directory called `logs`. Copy and paste `graph.ipynb` into this directory and execute the file to visualize the results.
