
# Teleportation With Null Space Gradient Projection for Optimization Acceleration

## Description

We propose a novel algorithm that projects the gradient of the teleportation objective onto the input null space to preserve the loss of primary task during teleportation. The proposed algorithm is efficient, has an explicit error control, and is generalizable to other modern architechtures such as CNNs and Transformers.

## Package Requirements

The necessary packages and their respective versions required to run this project are summarized in the `requirement.txt` file. Please refer to this file to ensure all dependencies are correctly installed to achieve optimal performance and functionality.

## Code Usage

Most experiments can be reproduced by directly running the `teleport_optimization.py` file after adjusting the setting inside the file. Important arguments are: dataset name, model type, learning rates, epochs, and teleportation schedule, etc. See appendix A2 in the paper.

Please use the graph.ipynb file for refined figure generation.

## Datasets

All datasets are public and can be found easily on the internet.

## Storage

Experiment models will be saved in a directory called `logs`, while the figures will be saved in a directory called `figures`. 