# Towards Generative Abstract Reasoning: Completing Raven’s Progressive Matrix via Rule Abstraction and Selection

This repository is the implementation of the paper "Towards Generative Abstract Reasoning: Completing Raven’s Progressive Matrix via Rule Abstraction and Selection".

## Requirements

To install requirements:

```setup
conda env create -f environment.yml
```

## Datasets

1. Prepare the [RAVEN](https://github.com/WellyZhang/RAVEN) and [I-RAVEN](https://github.com/husheng12345/SRAN) datasets.

2. Modify the dataset root in `dataset/build_RAVEN.sh` and `dataset/build_IRAVEN.sh`:

   ```setup
   python dataset/RAVEN/create_RAVEN.py \
     --dataset_root '<Your path to the root of RAVEN dataset>'\
     --size 64 \
     --output_path './cache'
   ```
   ```setup
   python dataset/IRAVEN/create_IRAVEN.py \
     --dataset_root '<Your path to the root of I-RAVEN dataset>'\
     --size 64 \
     --output_path './cache'
   ```

3. In the root, run

   ```setup
   ./create_dataset.sh
   ```

## Training

Change the conda environment

```
conda activate iclr2024-code
```

To train the model in the paper, run this command:

1. Center

   ```
   python train.py --dataset RAVEN --image_type center_single \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

2. L-R

   ```
   python train.py --dataset RAVEN --image_type left_center_single_right_center_single \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

3. U-D

   ```
   python train.py --dataset RAVEN --image_type up_center_single_down_center_single \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

4. O-IC

   ```
   python train.py --dataset RAVEN --image_type in_center_single_out_center_single \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

5. O-IG

   ```
   python train.py --dataset RAVEN --image_type in_distribute_four_out_center_single \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

6. 2$\times$2Grid

   ```
   python train.py --dataset RAVEN --image_type distribute_four \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

7. 3$\times$3Grid

   ```
   python train.py --dataset RAVEN --image_type distribute_nine \
   	--exp_name RAISE --model model_raise --gpu 0
   ```

## Evaluation

To evaluate models on all datasets, run this command:

```
./test.sh 0
```
where the parameter `0` is the gpu id used in test.

