# CellDiff

## Installation

```bash
conda create -n celldiff python=3.9 -y && conda activate celldiff

# PyTorch
conda install pytorch==2.0.1 torchvision torchaudio pytorch-cuda=11.8 -c pytorch -c nvidia -y

# PyG
conda install pyg==2.3.1 -c pyg

# RAPIDS
pip install cuml-cu11 cugraph-cu11 --extra-index-url=https://pypi.nvidia.com

# Other dependencies
pip install -r requirements.txt

# CellDiff
pip install -e .

conda clean --all -y
```

## Set up data

```bash
# Install gdown for downloading data and pre-trained models
pip install gdown

gdown https://drive.google.com/file/d/1Dbf1aX-OZ8FOGVEi4PhKiDRcvBOrnyAI/view?usp=sharing --fuzzy
tar -xzvf reproducibility.tar.gz && mv reproduce/ data/
```

## Run main evaluations

```bash
### Annotation experiments
SEED=10 bash run/run.sh annotation pbmc12k
SEED=10 bash run/run.sh annotation pancreas
SEED=10 bash run/run.sh annotation_cellxgene liver
SEED=10 bash run/run.sh annotation_cellxgene hlcasub
SEED=10 bash run/run.sh annotation_cellxgene immunesub
SEED=10 bash run/run.sh annotation_cellxgene brain

### Imputation experiments
SEED=10 bash run/run.sh denoising pbmc1k
SEED=10 bash run/run.sh denoising jurkat
SEED=10 bash run/run.sh denoising 293t

### Perturbation experiments
SEED=10 bash run/run.sh perturbation pbmc
SEED=10 bash run/run.sh perturbation hpoly
SEED=10 bash run/run.sh perturbation salmonella

### Gene perturbation experiments
SEED=10 bash run/run.sh genepert adamson
SEED=10 bash run/run.sh genepert dixit
SEED=10 bash run/run.sh genepert norman

### One-shot annotation experiments
SEED=10 TOPK=3 bash run/oneshot.sh
```
