# This is based on the run_gaia.py from https://github.com/huggingface/smolagents/tree/main/examples/open_deep_research
# Thanks for their great work!

import argparse
import json
import sys
import os

current_dir = os.path.abspath('.')
if current_dir not in sys.path:
    sys.path.insert(0, current_dir) 




import threading

from datetime import datetime
from pathlib import Path
from typing import List
from model_list import *
from config import *

import pandas as pd
from dotenv import load_dotenv
from huggingface_hub import login
from scripts.reformulator import prepare_response
from scripts.run_agents import (
    get_single_file_description,
    get_zip_description,
)
import nest_asyncio
nest_asyncio.apply()

from dotenv import load_dotenv
from scripts.text_inspector_tool import TextInspectorTool

from web_tools import *



from smolagents.vision_web_browser import (
    initialize_driver
)
from scripts.visual_qa import visualizer

from smolagents import (
    CodeAgent,
    Model,
    ToolCallingAgent
)
from helium import *
from prompt import *

from dotenv import load_dotenv


from smolagents import CodeAgent, tool
from smolagents.agents import ActionStep

AUTHORIZED_IMPORTS = [
        "requests",
    "zipfile",
    "os",
    "pandas",
    "numpy",
    "sympy",
    "json",
    "bs4",
    "pubchempy",
    "xml",
    "yahoo_finance",
    "Bio",
    "sklearn",
    "scipy",
    "pydub",
    "io",
    "PIL",
    "chess",
    "PyPDF2",
    "pptx",
    "torch",
    "datetime",
    "fractions",
    "csv",
    "helium",
    "math",
    "pandas",
    "openpyxl",
    "PIL"
]
load_dotenv(override=True)
append_answer_lock = threading.Lock()





def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--concurrency", type=int, default=1)
    parser.add_argument("--model-id", type=str, default="qwen3-32b-0shot")
    parser.add_argument("--run-name", type=str, required=True)
    parser.add_argument("--use-open-models", action="store_true")
    parser.add_argument("--set", type=str, default="url-ft")
    parser.add_argument("--dataset", type=str, default="gaia-text")
    parser.add_argument("--task", type=str, default="eval", help="eval, qa_construct")
    
    parser.add_argument("--thinking",action = 'store_true', default=False)
    
    args = parser.parse_args()
    return args





def create_agent_hierarchy(model: Model,save_name:str, agent_id:str, agent_name:str):
    text_limit = 100000
    ti_tool = TextInspectorTool(model, text_limit)

    manager_agent = CodeAgent(
        tools=[visualizer, ti_tool,]+[ DownloadTool(),MixedSearchTool(), go_back, 
               search_item_ctrl_f, visit_webpage, perform_click,perform_input
        ],
        model=model,
        additional_authorized_imports=AUTHORIZED_IMPORTS,
        max_steps=30,
        verbosity_level=2,
        planning_interval=31,
        traj_save_path = f"traj/{save_name}/{agent_name}/{agent_id}"
        
    )

    manager_agent.python_executor("from helium import *", )
    return manager_agent


def append_answer(entry: dict, jsonl_file: str) -> None:
    jsonl_file = Path(jsonl_file)
    jsonl_file.parent.mkdir(parents=True, exist_ok=True)
    with append_answer_lock, open(jsonl_file, "a", encoding="utf-8") as fp:
        fp.write(json.dumps(entry, ensure_ascii=False) + "\n")
    assert os.path.exists(jsonl_file), "File not found!"
    print("Answer exported to file:", jsonl_file.resolve())

def answer_single_question(args, question, model_id, answers_file, visual_inspection_tool):

    driver = initialize_driver()
    agent_id =  hash(question)
    
    model = automatedModelConstruction(model_id)
    print("Model Construction ok !")
    
    document_inspection_tool = TextInspectorTool(model, 100000)

    agent = create_agent_hierarchy(model, save_name=args.run_name, agent_id = agent_id,agent_name = args.model_id)


    augmented_question = eval_prompt.format(question = question)


    start_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        # Run agent 🚀
        if not args.thinking:
            final_result = agent.run(augmented_question+"/no_think")
        else:
            final_result = agent.run(augmented_question)
    driver.quit()






def main():
    args = parse_args()
    args.prompt = question_construct_format
    args.run_name = "quick_test"
    args.model_id = "qwen3-8b-webaggregator"
    
    print(f"Starting run with arguments: {args}")
    print(f"Total examples in dataset: {len(eval_ds)}")

    task_input = input("Please enter the task to run (leave empty to run all): ").strip()
    answer_single_question(args, example, args.model_id, answers_file, visualizer)

    print("All tasks processed.")
    

if __name__ == "__main__":
    main()
