
from smolagents import (
    HfApiModel,
    LiteLLMModel,
    OpenAIServerModel,
    AzureOpenAIServerModel

)
from openai import OpenAI

custom_role_conversions = {"tool-call": "assistant", "tool-response": "user"}

class AzureGPT4_1:
    def __init__(self,):  
        self.model = AzureOpenAIServerModel(
            model_id= "gpt-4.1",
            custom_role_conversions = custom_role_conversions,
            api_key="",  
            api_version="",
            azure_endpoint=""
        )

class LiteLLMClaude:
    def __init__(self, ):
        openai_api_key = "sk-1234"
        openai_api_base = "http://0.0.0.0:4000"
        
        self.client = OpenAI(
            api_key=openai_api_key,
            base_url=openai_api_base,
        )
        model_params = {
            "model_id": "claude",
            "api_key":openai_api_key,
            "custom_role_conversions": custom_role_conversions,
            "api_base":openai_api_base, 
            "max_completion_tokens": 4096,
        }
        self.model = OpenAIServerModel(**model_params)
   
class vLLMQWEN:
    def __init__(self, model_id):
        
        openai_api_key = "EMPTY"
        model_id2ip = {
            "qwen2.5-32b-0shot":"",
            
        }
        openai_api_base = model_id2ip[model_id]
        
        print(">>>> QWen series models, IP base is ", openai_api_base)
        self.client = OpenAI(
            api_key=openai_api_key,
            base_url=openai_api_base,
        )
        print("=========")
        models = self.client.models.list()
        print(models)
        
        self.model = models.data[0].id
        print(models)
        model_params = {
            "model_id": self.model,
            "api_key":openai_api_key,
            "custom_role_conversions": custom_role_conversions,
            "api_base":openai_api_base, 
        }
        self.model = OpenAIServerModel(**model_params)
        print(model_params)
        
def automatedModelConstruction(model_id):

    model_id2class = {'gpt-4.1':AzureGPT4_1, 'claude':LiteLLMClaude}
    if "qwen" in model_id:
        model = vLLMQWEN(model_id).model
    else:
        model = model_id2class[model_id]().model
    print(">>>>>>>>>>>>> model created")
    return model

class Whisper:
    def __init__(self):
        openai_api_key = "EMPTY"
        openai_api_base = "your_url"
        
        self.client = OpenAI(
        # defaults to os.environ.get("OPENAI_API_KEY")
        api_key=openai_api_key,
        base_url=openai_api_base,
        )
        models = self.client.models.list()
        self.model = models.data[0].id
    def sync_openai(self, file):
        with open(file, "rb") as f:
            transcription = self.client.audio.transcriptions.create(
                file=f,
                model=self.model,
                language="en",
                response_format="json",
                temperature=0.0)
        return transcription.text