# Hindsight-Sequence-Planner

<!-- Add paper link later -->
This repository is the official implementation of "Achieving Precise Control in Slow Hardware: A
Model-Based Reinforcement Learning Approach for
Action Sequence Learning".  

<!-- >📋  Optional: include a graphic explaining your approach/main result, bibtex entry, link to demos, blog posts and tutorials -->

![Diagram](images/HSPmodel.jpg "HSP Architecture")


## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

>📋  Describe how to set up the environment, e.g. pip/conda/docker commands, download datasets, etc...

## Training

To train the HSP models in the paper, run this command:

```train
python train_hsp.py --env_name Hopper-v2 --seed 0 --automatic_entropy_tuning True --steps 2 --actor_update_frequency 4
```
To replicate other results:
>📋  Change the env_name to: LunarLanderContinuous-v2, Walker2d-v2, Ant-v2, HalfCheetah-v2, Humanoid-v2 
> 
>📋  Change steps to: 4, 8, 16

## Evaluation

To evaluate the models on various action sequence lengths, similarly run:

```eval
python eval_gru.py --env_name Hopper-v2 --seed 0 --automatic_entropy_tuning True --steps 2 --actor_update_frequency 4
```

## Pre-trained Models

You can download pretrained models here:

- [My awesome model](https://drive.google.com/mymodel.pth) trained on ImageNet using parameters x,y,z. 

>📋  Give a link to where/how the pretrained models can be downloaded and how they were trained (if applicable).  Alternatively you can have an additional column in your results table with a link to the models.

## Results

Our model achieves the following performance on :

### [Image Classification on ImageNet](https://paperswithcode.com/sota/image-classification-on-imagenet)

| Model name         | Top 1 Accuracy  | Top 5 Accuracy |
| ------------------ |---------------- | -------------- |
| My awesome model   |     85%         |      95%       |

>📋  Include a table of results from your paper, and link back to the leaderboard for clarity and context. If your main result is a figure, include that figure and link to the command or notebook to reproduce it. 


## Contributing

>📋  Pick a licence and describe how to contribute to your code repository. 
