# Conservative Discrete Quantile Actor-Critic (CDQAC)

This repository contains the implementation of the Conservative Discrete Quantile Actor-Critic (CDQAC) algorithm.

# Installation
To install the required packages, run:

```bash
pip install -r requirements.txt
```

# Dataset Setup
The training datasets are stored in an **NPY** format, which consits of a list of dictionaries,
where each dictionary contains the following keys:
- 'jobLengths': A list of job lengths.
- 'OpPt': A list of operation processing times.

Other keys are action lists, that are used in the paper to train the model. To use your own dataset, edit [train_cdqac.py](train_cdqac.py) and [utils.py](offline_rl/utils.py) to load your own dataset.

# Config
The configuration file is located at [config.py](offline_rl/configs/cql_cdqac_config.py). You can modify the parameters according to your needs; however, the most important ones are CQL alpha and the policy frequency update.

# Training
To train the model, run the following command:

```bash
python train_cdqac.py
```