library(readxl)
ADNI_use <- read_excel("~/R/data_save/ADNI_use.xlsx")
#"Hippocampus" "Recall"      "orientation" "Age"         "Gender"      "Eduyear" 
X<-ADNI_use[,c("Age","Gender","Eduyear")]
A<-ADNI_use$Recall
Y<-ADNI_use$Hippocampus
Z<-ADNI_use$orientation
n<-nrow(ADNI_use)
num.trees= 4000
clusters= numeric(0)
sample.weights = NULL;equalize.cluster.weights = FALSE
samples.per.cluster<- validate_equalize_cluster_weights(equalize.cluster.weights, clusters, sample.weights)
sample.fraction= 0.5
mtry= 8
min.node.size= 6
honesty= TRUE
honesty.fraction= 0.5
honesty.prune.leaves= TRUE
alpha= 0.05
imbalance.penalty= 0
stabilize.splits= TRUE
ci.group.size= 4
compute.oob.predictions = TRUE
num.threads= 0
seed=runif(1, 0, .Machine$integer.max)
tune.parameters = "none";

numerator_1<-numerator_0<-denominator_1<-denominator_0<-add_1<-add_0<-rep(1,n)
data <- create_train_matrices(X,X, outcome = A, instrument = rep(0,n),sample.weights = sample.weights,numerator_1=numerator_1,denominator_1=denominator_1,add_1=add_1,
                              numerator_0=numerator_0,denominator_0=denominator_0,add_0=add_0
                              ,outcome_t = A)
args <- list(num.trees = num.trees,
             clusters = clusters,
             samples.per.cluster = samples.per.cluster,
             sample.fraction = sample.fraction,
             mtry = mtry,
             min.node.size = min.node.size,
             honesty = honesty,
             honesty.fraction = honesty.fraction,
             honesty.prune.leaves = honesty.prune.leaves,
             alpha = alpha,
             imbalance.penalty = imbalance.penalty,
             ci.group.size = ci.group.size,
             compute.oob.predictions = compute.oob.predictions,
             num.threads = num.threads,
             seed = seed,
             legacy.seed = get_legacy_seed())
forest <- do.call.rcpp(regression_train, c(data, args))
W.hat <- forest$predictions
W.centered <- A - W.hat
W.centered <-W.centered*1.2
# W.centered<-rep(1,n)
num.trees = 3000;
sample.weights = NULL;
clusters = NULL;
equalize.cluster.weights = FALSE;
sample.fraction = 0.5;
# mtry = min(ceiling(sqrt(ncol(X)) + 20), ncol(X));
mtry = 10;

min.node.size = 5;
honesty = TRUE;
honesty.fraction = 0.5;
honesty.prune.leaves = TRUE;
alpha = 0.05;
imbalance.penalty = 0;
ci.group.size = 5;
tune.parameters = "none";
tune.num.trees = 50;
tune.num.reps = 100;
tune.num.draws = 1000;
compute.oob.predictions = TRUE;
num.threads = NULL;
seed = runif(1, 0, .Machine$integer.max)
validate_sample_weights(sample.weights, X)
Y <- validate_observations(Y, X)
clusters <- validate_clusters(clusters, X)
samples.per.cluster <- validate_equalize_cluster_weights(equalize.cluster.weights, clusters, sample.weights)
num.threads <- validate_num_threads(num.threads)

all.tunable.params <- c("sample.fraction", "mtry", "min.node.size", "honesty.fraction",
                        "honesty.prune.leaves", "alpha", "imbalance.penalty")
default.parameters <- list(sample.fraction = 0.5,
                           mtry =10, # min(ceiling(sqrt(ncol(X)) + 20), ncol(X)),
                           min.node.size = 7,
                           honesty.fraction = 0.5,
                           honesty.prune.leaves = TRUE,
                           alpha = 0.05,
                           imbalance.penalty = 0)
# data<-list()
data <- create_train_matrices(X,X, outcome = Y, instrument = W.centered,sample.weights = sample.weights,numerator_1=numerator_1,denominator_1=denominator_1,add_1=add_1,
                              numerator_0=numerator_0,denominator_0=denominator_0,add_0=add_0
                              ,outcome_t = Y)
#truth_Y
mtry=7
args <- list(num.trees = 2000,
             clusters = clusters,
             samples.per.cluster = samples.per.cluster,
             sample.fraction = sample.fraction,
             mtry = mtry,
             min.node.size = min.node.size,
             honesty = honesty,
             honesty.fraction = honesty.fraction,
             honesty.prune.leaves = honesty.prune.leaves,
             alpha = alpha,
             imbalance.penalty = imbalance.penalty,
             ci.group.size = ci.group.size,
             compute.oob.predictions = compute.oob.predictions,
             num.threads = num.threads,
             seed = seed,
             legacy.seed = get_legacy_seed())
forest <- do.call.rcpp(regression_train, c(data, args))
preds = forest$predictions
hist(preds)
