function T=tree_gini_split(node,T,X,Y,d,Depth,d_S_s)

T.leaf_class(node)= mode(Y);
T.NodeSize(node,1)=size(X,1);


if (d==Depth)   || (numel(unique(Y))<=1)  || size((unique(X,'rows')),1)<=1
  T.Children(node,:)=[0 0];
  T.feature(node)=-1;
  T.threshold(node)=NaN;
  T.Impurity(node)=0;
  T.comp(node)=0;
  return
end


%      [feature,threshold,Impurity,Node_complexity]=Feature_importance_b2(X,Y);%,d_S_s);
     [feature,threshold,Impurity,Node_complexity]=Feature_importance(X,Y,d_S_s);
    
    if ( feature == -1 || isnan(threshold) || isnan(Impurity)||...
            Impurity == inf ||threshold == inf)
        
        T.Children(node,:)=[0 0];
        T.feature(node)=-1;
        T.threshold(node)=NaN;
        T.Impurity(node)=0;
        T.comp(node)=0;
      return
    end   
    T.comp(node)=Node_complexity;
    left_index=X(:,feature)<=threshold;
    right_index=X(:,feature)>threshold;
    left_class=Y(left_index);
    left_X=X(left_index,:);
    right_class=Y(right_index);
    right_X=X(right_index,:);
    T.feature(node)=feature;
    T.threshold(node)=threshold;
    T.Impurity(node)=Impurity;
    num_nodes= size(T.Children,1);
    T.Children(node,:)=[num_nodes+1 num_nodes+2];
    T.Children(num_nodes+1,:)=[0 0];
    T.Children(num_nodes+2,:)=[0 0];

   

T=tree_gini_split(num_nodes+1,T,left_X,left_class,d+1,Depth);%,d_S_s);
T=tree_gini_split(num_nodes+2,T,right_X,right_class,d+1,Depth);%,d_S_s);

end