# AesStyler

Official Pytorch code for <strong>AesStyler: Aesthetic Guided Universal Style Transfer</strong>

[//]: # (## Introduction:)

[//]: # ()
[//]: # (**AesUST** is a novel Aesthetic-enhanced Universal Style Transfer approach that can generate aesthetically more realistic and pleasing results for arbitrary styles. It introduces an aesthetic discriminator to learn the universal human-delightful aesthetic features from a large corpus of artist-created paintings. Then, the aesthetic features are incorporated to enhance the style transfer process via a novel Aesthetic-aware Style-Attention &#40;AesSA&#41; module. Moreover, we also develop a new two-stage transfer training strategy with two aesthetic regularizations to train our model more effectively, further improving stylization performance. )

[//]: # ()
[//]: # (## Environment:)

[//]: # (- Python 3.6)

[//]: # (- Pytorch 1.8.0)

[//]: # (## Getting Started:)

[//]: # (**Clone this repo:**)

[//]: # ()
[//]: # (`git clone https://github.com/EndyWon/AesUST`  )

[//]: # (`cd AesUST`)
## Codebook
- First select the top 1000 images with highes aesthetic score in WikiArt dataset and copy them into a new directory(Remeber to replace the path in copy_image.py with your own paths).
  ```
  python select_image.py --path_to_images PATH_TO_WIKIART
  python copy_image.py
  ```
- Compute the style features and store them:
  <br><br>
  `python compute_style_feature.py --path_to_images ./wikiart_high_score`
<br><br>
- Compute the aesthetic features and store them:
<br><br>
  `python compute_aesthetic_feature.py --path_to_images ./wikiart_high_score`
  
## Train:

- Download content dataset [MS-COCO](https://cocodataset.org/#download) and style dataset [WikiArt](https://www.kaggle.com/c/painter-by-numbers) and then extract them.


- Download the pre-trained [TANet](https://github.com/woshidandan/TANet), Unzip and place them at `checkpoints/tanet`.


- Download the pre-trained [AdaAttN](https://drive.google.com/file/d/1XvpD1eI4JeCBIaW5uwMT6ojF_qlzM_lo/view), Unzip and place them at `checkpoints/adattn`.
<br><br><br>
- Run train script:
<br><br>
  `python train.py --content_dir PATH_TO_COCO2014 --style_dir PATH_TO_WIKIART`
<br><br>
  After the training, the model checkpoints are save in `./exp`.


## Test:
- Test two paired collections of images(one content iamge paired with one styl image):
<br><br>
  `python test.py --content_dir inputs/content/ --style_dir inputs/style/`
  <br><br>
  The style transfer results are saved in `./outputs`.
<br><br><br>
- Test two collections of images(all possible combinations):
<br><br>
  `python test_deception.py --content_dir inputs/content/ --style_dir inputs/style/`
<br><br>
  The style transfer results are saved in `./outputs_deception`.




