import pandas as pd
import shutil
import os

# 读取CSV文件
csv_file = 'art_scores.csv'  # 替换为你的CSV文件路径
output_folder = './wikiart_high_score'   # 替换为你的输出文件夹路径
os.makedirs(output_folder, exist_ok=True)

# 读取CSV文件并按分数排序
data = pd.read_csv(csv_file)
data = data.sort_values(by='Score', ascending=False)

# 选择前5000张图片
top_1000 = data.head(1000)

# 复制图片到新文件夹
for index, row in top_1000.iterrows():
    image_name = row['Image']
    source_path = os.path.join('PATH_TO_WIKIART', image_name)  # 替换为你的图片路径
    destination_path = os.path.join(output_folder, image_name)
    shutil.copy(source_path, destination_path)

