# R-Pool

This is the implementation of the "R-Pool", which is proposed in our paper: "Adversarially Robust Graph Classification: A Pooling-Based Defense Framework".

The main idea is to use a filtering method before the pooling operation such as to discard the nodes that are vulnerable to adversarial attacks. For that purpose, we fit a GMM and we use an OOD-score.

## Requirements

Code is written in Python 3.6 and requires:
- PyTorch
- Torch Geometric
- NetworkX

## Datasets
We base our experimental results on the classical graph datasets:
- PROTEINS
- NCI1
- IMDB-BINARY

All of these datasets are part of TUDataset, which can directly be uploaded online.


## Training and Evaluation

To train and evaluate the model in the paper, the user should specify the following :

- Dataset : The dataset to be used
- Threshold: The threshold to be used with the OOD-Score.

To run a normal code of GCN with the PGD attack using the PROTEINS dataset and using the default parameters for a 30% budget:

```bash
python attack_pgd.py --dataset PROTEINS
```

To run our R-Pool on top of the GCN.

```bash
python defense_pgd.py --dataset PROTEINS
```

## Additional Details

For the other attacks, we directly adapted our code to use the DGL package and we used the public implementation that were provided with the paper "Adversarial Attacks on Graph Classification via Bayesian Optimisation".

For additional details about the architecture and the approach, please refer to the paper. 
