import os

from .navigation import Navigation
from .procgen import Procgen

simulator_config = os.environ.get("SIMULATOR")

if simulator_config == "navigation-2exits":
    SIMULATOR = Navigation
    SIMULATOR.n_exits = 2
elif simulator_config == "navigation-1exit":
    SIMULATOR = Navigation
    SIMULATOR.n_exits = 1
elif simulator_config in {
    "bigfish",
    "bossfight",
    "caveflyer",
    "chaser",
    "climber",
    "coinrun",
    "dodgeball",
    "fruitbot",
    "heist",
    "jumper",
    "leaper",
    "maze",
    "miner",
    "ninja",
    "plunder",
    "starpilot",
}:
    SIMULATOR = Procgen
else:
    raise NotImplementedError("Invalid value for SIMULATOR!")
