class BaseSimulator:
    max_steps = 0

    def __init__(self):
        self.state = None
        self.timestep = 0

    def reset(self):
        raise NotImplementedError

    def step(
        self,
        action,
    ):
        raise NotImplementedError

    def render(
        self,
        as_image=True,
    ):
        raise NotImplementedError

    def is_solved(self):
        raise NotImplementedError

    def state_tensor(self):
        raise NotImplementedError
