# ICLR 2026 Submission - Anonymous Code

This contains the anonymized code used to reproduce the main experimental results in our ICLR 2026 submission titled:

**"Sobolev Gradient Ascent for Optimal Transport: Barycenter Optimization and Convergence Analysis"**
  
## Dependencies
- numpy
- matplotlib
- scipy
- kagglehub
- PIL
- BFM
- mpl_toolkits
- skimage
- POT
- pybind11

To install the packages,
```bash
pip install -r requirements.txt
```

To build the pybind11 modules for using the functions in the BFM package, follow these steps:
```bash
cd Case2D
g++ `python3 -m pybind11 --includes` w2.cpp -o w2.so -shared -fPIC -undefined dynamic_lookup
```
This will compile w2.cpp into a Python-importable module named w2.so.


In 3D cases, 
```bash
cd Case3D 
g++ `python3 -m pybind11 --includes` w23d_.cpp -o w23d_.so -shared -fPIC -undefined dynamic_lookup
```
This will compile w23d_.cpp into a Python module named w23d_.so, which exposes the corresponding 3D class and functions.



## Instructions

All file paths referencing local directories have been removed to preserve anonymity. Please update them to match your local environment as needed.

### 2D Experiments

The `Case2D` folder includes the following scripts:

- `experiment1.py`: Reproduces the experiment in **Section 5.1**.
- `experiment1_1.py`: Reproduces **Figure 1** from the paper.
- `experiment2.py`: Reproduces the experiment in **Section 5.2**.
- `plot1.ipynb`: Analyzes the results from **Section 5.1**.
- `plot2.ipynb`: Visualizes the results from **Section 5.2**.

### 3D Experiments

The `Case3D` folder includes:

- `2shapes.py`: Reproduces the experiment in **Section 5.3**.
- `Visualization.ipynb`: Analyzes and visualizes the results from **Section 5.3**.

### Running the Code

To run an experiment, navigate to the appropriate folder and execute the script. For example:

```bash
cd Case2D
python experiment1.py
```
