# Interpretable GNN

This repository is the official implementation of [Interpretable GNN](https://neurips.cc). 


![visulisation-web-ui](https://user-images.githubusercontent.com/6986867/166146644-da693f32-c0d9-44bf-8abe-5b60f3b8b253.jpg)

The demo of the Visualisation Tool can be accessed via the following [Link](https://interpretable-gnn.netlify.app).

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```
Sometimes pip tries to install torch-scatter, torch-geometric, ... before torch and will fail. In this case manually install torch first and rerun the command

## Training

To train the model(s) in the paper, run this command:

```train
python train.py --dataset <name_of_the_dataset> --state_space 10 --number_of_layers 5
```

## Visualisations

To run the visualization Tool locally using docker run the following command:
```train
cd visualization && docker-compose up
```

## Explanation Export

To export the explanations to the locally running visualization Tool run the following command:
```train
python export.py --dataset <name_of_the_dataset> --model_path <path to the trained model .pt file> --number_of_layers <layers used during training>
```

The Saturation and Infection datasets work most stable when setting --batch_size=1 for training and exporting
