import React from 'react';
import {atom, useAtom} from 'jotai'
import Col from 'antd/es/col';
import InputNumber from 'antd/es/input-number';
import Row from 'antd/es/row';
import Divider from 'antd/es/divider';
import Slider from 'antd/es/slider';
import Radio from 'antd/es/radio';
export const cutoffValueAtom = atom(0.05)
export const selectedSampleAtom = atom(undefined)
export const selectedDatasetAtom = atom(undefined)
export const inputOutputSelectedAtom = atom('output')

const Settings = () => {
    const [cutoff, setCutoff] = useAtom(cutoffValueAtom);
    const [inputOutputSelected, setInputOutputSelected] = useAtom(inputOutputSelectedAtom);

    const onInputOutputSelect = (e) => {
        setInputOutputSelected(e.target.value)
    };


    return (
        <div>
            <Divider orientation="left">Cutoff Value</Divider>
            <Row>
                <Col span={16}>
                    <Slider
                        min={0}
                        max={1}
                        onChange={(value) => setCutoff(value)}
                        value={typeof cutoff === 'number' ? cutoff : 0}
                        step={0.01}
                    />
                </Col>
                <Col span={3}>
                    <InputNumber
                        min={0}
                        max={1}
                        style={{margin: '0 16px'}}
                        step={0.01}
                        value={cutoff}
                        onChange={(value) => setCutoff(value)}
                    />
                </Col>
            </Row>
            <Divider orientation="left">Show Node Input/Output State</Divider>
            <Radio.Group value={inputOutputSelected} buttonStyle="solid" onChange={onInputOutputSelect}>
                <Radio.Button value="input">Input</Radio.Button>
                <Radio.Button value="output">Output</Radio.Button>
            </Radio.Group>
        </div>
    );
};

export default Settings;
