import random

hp_space = {
        "grd_prompt_id": ('categorial', list(range(10))),
        "bst_n_clusters": ('int', [0, 5]),
        
        # HSV shift for grounding
        "grd_hsv_hue_shift": ('int', [0, 20]),  # [0, 20] means the value range is [0, 20]
        "grd_hsv_sat_shift": ('int', [0, 30]),
        "grd_hsv_val_shift": ('int', [0, 30]),
        # HSV shift for segmentation
        "seg_hsv_hue_shift": ('int', [0, 20]),
        "seg_hsv_sat_shift": ('int', [0, 30]),
        "seg_hsv_val_shift": ('int', [0, 30]),

        # RGB shift for grounding
        "grd_r_shift": ('int', [0, 20]),
        "grd_g_shift": ('int', [0, 20]),
        "grd_b_shift": ('int', [0, 20]),
        # RGB shift for segmentation
        "seg_r_shift": ('int', [0, 20]),
        "seg_g_shift": ('int', [0, 20]),
        "seg_b_shift": ('int', [0, 20]),

        # CLAHE for grounding
        "grd_clahe_clip": ('float', [0, 4]),
        "grd_clahe_grid":  ('int', [1, 4]),
        # CLAHE for segmentation
        "seg_clahe_clip": ('float', [0, 4]),
        "seg_clahe_grid": ('int', [1, 4]),

        # Edge enhancement
        "grd_edge_strength": ('float', [0, 1]),
        "seg_edge_strength": ('float', [0, 1])
}

def random_hp():
    """Randomly sample a set of parameters from reasonable ranges for both grounding and segmentation models."""
    hp = {}
    for name, (val_type, val_cfg) in hp_space.items():
        if val_type == 'categorial':
            val = random.choice(val_cfg)
        elif val_type == 'int':
            val = random.randint(val_cfg[0], val_cfg[1])
        elif val_type == 'float':
            val = random.uniform(val_cfg[0], val_cfg[1])
        else:
            assert 'wrong val_type %s' % val_type
        hp[name] = val
    return hp

def default_hp():
    hp = {}
    for name, (val_type, val_cfg) in hp_space.items():
        hp[name] = val_cfg[0]

    return hp
