import os
import sys
import json
import configparser
import random
from types import SimpleNamespace

def read_hp_config(data_name):
    config = configparser.ConfigParser()

    ini_path = f'configs/{data_name}.ini'
    config.read(ini_path)

    if 'ARGS' not in config:
        raise ValueError("Expected [ARGS] section in INI file.")

    parsed_dict = {}
    for key, value in config['ARGS'].items():
        # Try to parse lists and tuples
        if ',' in value:
            items = [v.strip() for v in value.split(',')]
            # Try to convert to float or int if applicable
            try:
                items = [eval(v) if v.replace('.', '', 1).isdigit() else v for v in items]
            except:
                pass
            parsed_value = tuple(items) if key.endswith('_range') else items
        else:
            # Try to convert to float/int/bool when possible
            try:
                parsed_value = eval(value)
            except:
                parsed_value = value

        parsed_dict[key] = parsed_value

    if not 'center_x_range' in parsed_dict:
        parsed_dict['center_x_range'] = [0, 1]
    if not 'center_y_range' in parsed_dict:
        parsed_dict['center_y_range'] = [0, 1]

    args = SimpleNamespace(**parsed_dict)

    # Load prompt list
    grounding_prompt_file = os.path.join('grounding_prompts', data_name) + '.txt'
    args.grounding_prompt_list = [s.strip() for s in open(grounding_prompt_file).readlines()]
    print('%d grounding prompts loaded from %s' % (len(args.grounding_prompt_list), grounding_prompt_file))

    validation_constrat_file = os.path.join('validator_contrast_classes', data_name) + '.txt'
    args.contrastive_parts = [s.strip().lower() for s in open(validation_constrat_file).readlines()]
    args.contrastive_parts += ['background']
    print('%d contrastive classes loaded from %s' % (len(args.contrastive_parts), validation_constrat_file))
    print('contrastive classes: %s' % args.contrastive_parts)

    validation_prompt_file = os.path.join('validator_prompts', data_name) + '.txt'
    args.validation_prompt_list = [s.strip() for s in open(validation_prompt_file).readlines()]
    print('%d validation prompts loaded from %s' % (len(args.validation_prompt_list), validation_prompt_file))

    validation_rule_file = os.path.join('validator_rules', data_name) + '.txt'
    v = [float(s.strip()) for s in open(validation_rule_file).readlines()]
    print('rule numbers %s' % str(v))
    args.area_range = v[0], v[1]
    args.center_x_range = v[2], v[3]
    args.center_y_range = v[4], v[5]

    args.test_images = [x.strip() for x in open(args.test_image_list).readlines()]

    if len(args.test_images) > 100:
        args.val_images = random.sample(args.test_images, k=100)
    else:
        args.val_images = args.test_images

    args.task_name = data_name

    return args
#print(args)
