# DMesh: A Differentiable Mesh Representation

By computing existence probability for faces in a mesh, DMesh offers a way to represent a general triangular mesh in a differentiable manner.

## Usage

Here we provide some examples to use DMesh. All of the examples use config files in `exp/config` folder. You can modify the config files to change the input/output paths, hyperparameters, etc. By default, all the results are stored in `exp_result`. If you want to run every experiment sequentially, please use the following command.

```bash
bash run_all.sh
```

### Example 1: Mesh to DMesh

First, we convert a ground truth mesh to DMesh, by restoring the connectivity of the given mesh.

Run following command to convert Stanford Bunny model into DMesh.

```bash
python exp/1_mesh_to_dmesh.py --config=exp/config/exp_1/bunny.yaml
```

### Example 2: Point cloud reconstruction

Next, we reconstruct a 3D mesh from a point cloud using DMesh, by minimizing (expected) Chamfer Distance.

Run following command to reconstruct a Lucy model from a point cloud.

```bash
python exp/2_pc_recon.py --config=exp/config/exp_2/thingi32/252119.yaml
```

### Example 3: Multi-view image reconstruction

Finally, we reconstruct a 3D mesh from multi-view (diffuse, depth) images using DMesh, by minimizing the rendering loss.

Run following command to reconstruct a cloth model from multi-view images.

```bash
python exp/3_mv_recon.py --config=exp/config/exp_3/deepfashion3d/448.yaml
```