This is the code for the anonymous CVPR 2022 submission # 464 . Please dont share. Here are the procesdures to run the code. 

## Requirement
This code is tested with Python 3.7 and Pytorch >= 1.8

- install Pytorch3d from [here](https://github.com/facebookresearch/pytorch3d/blob/master/INSTALL.md)
```bash
conda create -y -n mvpt python=3.7
conda activate mvpt
conda install -c pytorch pytorch=1.8.0 torchvision cudatoolkit=10.2
conda install -c fvcore -c iopath -c conda-forge fvcore iopath
conda install -c bottler nvidiacub
conda install pytorch3d -c pytorch3d
``` 

- install other helper libraries 

```bash
conda install -y pandas
conda install -y -c conda-forge trimesh
pip install imageio einops scipy matplotlib ptflops tensorboard h5py pptk metric-learn
``` 

- install vision helper library timm 
```bash
pip install git+https://github.com/rwightman/pytorch-image-models

``` 

## Usage

The main Python script in the root directorty `run_voint.py`. 

First download the following datasets and unzip inside the `data/` directories as follows: 

- ModelNet40 . 

- ShapeNet Core55 v2 [official link](https://shapenet.org/download/shapenetcore) ( You need to create an account) 

- ScanObjectNN (ScanObjectNN with its three main variants [`obj_only` ,`with_bg` , `hardest`] should be controlled by the `--dset_variant` option  ). 

- ShapeNet Parts ( type `wget https://shapenet.cs.stanford.edu/media/shapenet_part_seg_hdf5_data.zip --no-check-certificate` in the command line). 

Then you can run Voint with 
```bash
python run_voint.py --data_dir data/ModelNet40/ --run_mode train_cls --mvnetwork vit --nb_views 12 --views_config spherical  
```
- `--data_dir` the data directory. The dataloader is picked adaptively from `custom_dataset.py` based on the choice between "ModelNet40", "shapenet_part", "ShapeNetCore.v2", or the "ScanObjectNN" choice.
- `--run_mode` is the run mode. choices: "train_part"(train for 3D part segmentation), "test_part"(test part segmentation after training), "train_cls"(train for classification), "test_cls"(test classification after training), "test_retr"(test retrieval after training), "test_rot"(test rotation robustness after training), "test_occ"(test occlusion robustness after training)
- `--mvnetwork` is the 2D backbone used in the pipeline. Choices: "deeplab" , "vit","fcn ,"resnet"
- `--views_config`  choices: "circular", "random", "spherical".
- `--resume` continue training from last checkpoint.


Other parameters can be founded in `config.yaml` configuration file or run `python run_voint.py -h`. The default parameters are the ones used in the paper.

The results will be saved in "results/`exp_set`/`exp_id`/" folder that contaions the camera view points and the renderings of some example as well the checkpoints and the logs.
<br>


## Other files
- `models/voint.py` contains the main Voint classes and functions.
- `models/renderer.py` contains the main Pytorch3D  differentiable renderer class that can render multi-view images for point clouds and meshes adaptively.
- `models/mvtn.py` a view selecter.
- `custom_dataset.py` includes all the pytorch dataloaders for 3D datasets: ModelNEt40, SahpeNet core55 ,ScanObjectNN, and ShapeNet Parts 


## Acknoledgements
This paper and code borrows codes and ideas from several great github repos:
[MVCNN pytorch](https://github.com/RBirkeland/MVCNN-PyTorch) , [MVTN](https://github.com/ajhamdi/MVTN) and most importantly the great [Pytorch3D](https://github.com/facebookresearch/pytorch3d) library.
## License
The code is released under MIT License (see LICENSE file for details).
