# Install MoE-PEFT

## Linux (Ubuntu, Debian, Fedora, etc.)

### Requirements

- One or more NVIDIA GPUs
  - At least 16GB VRAM per card
  - Cards with Ampere or newer architecture will perform faster
- Installation of the [latest graphics driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) and [CUDA toolkit](https://developer.nvidia.com/cuda-downloads)
- `conda` installed and configured
- Internet connection for automated tasks

### Steps

```bash
# Optional but recommended
conda create -n moe_peft python=3.11
conda activate moe_peft
# Install requirements
pip3 install -r requirements.txt --upgrade
# Install extra requirements
pip3 install ninja
pip3 install bitsandbytes==0.43.1
pip3 install flash-attn==2.5.8 --no-build-isolation
```

## Verification

From the command line, type:

```bash
python
```

then enter the following code:

```python
import moe_peft
moe_peft.setup_logging("INFO")
moe_peft.executor.check_available()
```

Expected output:

```
MoE-PEFT: NVIDIA CUDA initialized successfully.
```
