# Supplementary Materials of ICLR 2025 Submission #788

Dear reviewers, this directory contains the supplementary materials for ICLR 2025 submission \#788. It includes the code required to replicate the complete experiments described in the paper.

## Reproducibility Statement

To reproduce the evaluation results presented in our paper, please follow the instructions below.

### Install Requirements

Refer to [Install.md](./Install.md) for details on installing the necessary dependencies.

### Environments

Our experiments were conducted in the following hardware environments:

- Systems with x86-64 CPUs
- NVIDIA GPUs: RTX 3090 (24GB), RTX A5000 (24GB), RTX 4090D (24GB), RTX 4090 (24GB), and RTX A6000 (48GB)

### Hyperparameters

All hyperparameter configurations can be found in the [templates](./templates/) folder.

### Main Experiment

The following script requires an internet connection to download the models, metrics, and datasets from HuggingFace Hub.

```bash
python ./launch.py gen --template mixlora --tasks <glue:rte/arc-c/arc-e/boolq/obqa/piqa/siqa/hellaswag/winogrande>
python ./launch.py run --base_model <Path or Name to Your Base Model>
```

## Implementation of DynMoLE

The implementation of DynMoLE can be found in the directory [moe_peft/adapters/dynmole](./moe_peft/adapters/dynmole/). The core routing algorithm is located in the function `_dynamic_routing`, and the core loss function is implemented in `_dynamic_load_balancing_loss_func`.
