[# 程序运行
]()
## 1. 环境与代码：
支持 python >= 3.10, pytorch >= 2.0
```shell
pip install -r requirement.txt
```
环境：lit-tsf

## 2. 准备数据集

path

## 3. 运行
 
### 3.1 同时跑4个步长：
  ```shell
  bash ./sum/数据集.sh >数据集.txt
  ```
  - 修改 /data0/Wendy/code/KAN/LRKAN/config/dataName.py 中的数据集名称、KAN的种类;
  - 再改bash中SAVE_ROOT中子文件夹

### 3.2 跑一个步长：
  ```shell
  python run.py
  ```
  - 修改 /data0/Wendy/code/KAN/LRKAN/config/dataName.py 中的数据集名称、KAN种类；
  - 再修改 /data0/Wendy/code/KAN/LRKAN/config/base_conf/long_time_series_forecasting.py 中的步长


## 4. 调参
```shell
python ray_tune.py
```

一个简单的超参数搜索命令：
```shell
python ray_tune.py -c /data0/Wendy/code/KAN/LRKAN/config/basicSetting.py -p /data0/Wendy/code/KAN/LRKAN/config/seed_space.py
```


## 代码结构

```
- easytsf
  - easytsf
    - data
    - layer
    - util
    - runner
  - config
  - dataset
  - script
  - save
    - [model_name]_[dataset_name]
      - [config_hash]
        - seed_x
          - checkpoints
          - hparams.yaml
          - metric.csv
```
PS:
计算 config_hash 的时候，默认去除 ['seed', 'data_dir', 'save_dir', 'use_wandb']



## 技术框架介绍

Lightning
Trainer:
 - devices: 
   1. 输入int，表示使用的device的数量，一般代表显卡数量；
   1. 输入list[int]，表示使用的device编号；
   1. 输入str，如果符合 int 格式，比如'1', 按照 int 处理；如果类似 '0,1'，按照 list[int]处理；其他则报错。

   train.py 函数使用字符串输入，'1,'表示使用 1 号 GPU；'1'表示使用一个 GPU，选取GPU的策略由 accelerator 决定; "auto" 表示由程序决定