import os

import pandas as pd
import yaml


def get_report(trial_dir):
    data = pd.read_csv(os.path.join(trial_dir, "seed_0/metrics.csv"))
    trial_param_path = os.path.join(trial_dir, "seed_0/hparams.yaml")

    special_params = []
    with open(trial_param_path, 'r') as f:
        hparams = yaml.unsafe_load(f.read())
    for hparam_name in ["d_pgt", "n_layer", "patch_len", "n_pattern", "batch_size", "lr"]:
        special_params.append(hparams[hparam_name])

    return data.iloc[-1]["test/loss"], special_params


report = []
for trial_dir in os.listdir("save/PGTPretrained_Weather"):
    try:
        test_loss, hparams = get_report(os.path.join("save/PGTPretrained_Weather", trial_dir))
        report.append([trial_dir] + hparams + [test_loss])
    except:
        continue
report_df = pd.DataFrame(
    report, columns=["conf_hash", "d_pgt", "n_layer", "patch_len", "n_pattern", "batch_size", "lr", "test/loss"])
report_df.to_csv("pgt.csv")
