import seaborn as sns
import os
import matplotlib as mpl
from matplotlib import pyplot as plt
cmap = plt.get_cmap('tab10')
import glob
import numpy as np
from scipy import stats

step_size = 10000

def main(root,env_name
         ):

    
    print(f'{env_name}')
    for id,method_folder in enumerate(glob.glob(f'{root}/{env_name}/*')):
        method_name = method_folder.split('/')[-1]
        print('\t\t\t',method_name)
        folder = method_folder
        cnt = 0
        numbers = []
        for file in glob.glob(f'{glob.escape(folder)}/*.txt'):
            cnt += 1
            with open(file) as f:
                arr = np.array([float(line.split('\n')[0]) for line in f.readlines()])[:100]
            assert arr.shape[0]>=100
            numbers.append(arr[-20:])
        
        if (cnt):
            numbers = np.concatenate(np.array(numbers))
            std = np.std(numbers)
            print(f'\t\t [{cnt}] {{score_details}}:\t${np.mean(numbers):.1f}_{{\pm {std:.1f}}}$')
        else:
            print(f'\t\t [{cnt}]:\tNone')
        print('-'*100)

if __name__ == '__main__':
    root = './txt_data'
    envs = [
        'halfcheetah',
        # 'ant',
        # 'hopper',
        # 'walker2d',
        # 'pen',
        # 'hammer',
        # 'door',
        # 'relocate',
        # 'kitchen',
        ]
    for env in envs:
        main(root,env)