## Alsa

mkdir -p ~/local/bin ~/local/lib

cd ~/
rm -rf alsa-lib-1.2.8 alsa-utils-1.2.8
rm -rf ~/local/lib/libasound* ~/local/include/alsa ~/local/lib/pkgconfig/alsa.pc ~/local/share/alsa

wget ftp://ftp.alsa-project.org/pub/lib/alsa-lib-1.2.8.tar.bz2
tar xjf alsa-lib-1.2.8.tar.bz2
cd alsa-lib-1.2.8
./configure \
    --prefix=$HOME/local \
    --enable-shared \
    --disable-static
make && make install

# Set more explicit library paths
export PKG_CONFIG_PATH="$HOME/local/lib/pkgconfig:$PKG_CONFIG_PATH"
export LDFLAGS="-L$HOME/local/lib -Wl,-rpath,$HOME/local/lib"
export LD_LIBRARY_PATH="$HOME/local/lib:$LD_LIBRARY_PATH"
export CPPFLAGS="-I$HOME/local/include"

cd ~/
wget ftp://ftp.alsa-project.org/pub/utils/alsa-utils-1.2.8.tar.bz2
tar xjf alsa-utils-1.2.8.tar.bz2
cd alsa-utils-1.2.8
make clean
./configure \
    --prefix=$HOME/local \
    --disable-alsamixer \
    --disable-xmlto \
    --disable-nls \
    --with-systemdsystemunitdir=$HOME/local/lib/systemd/system \
    --with-udev-rules-dir=$HOME/local/lib/udev/rules.d \
    --with-asound-state-dir=$HOME/local/var/lib/alsa \
    --with-alsa-prefix=$HOME/local \
    --with-alsa-inc-prefix=$HOME/local/include
make && make install

# Pulseaudio

export PATH="$HOME/local/bin:$PATH"
export LD_LIBRARY_PATH="$HOME/local/lib:$HOME/local/lib64:$LD_LIBRARY_PATH"
export PKG_CONFIG_PATH="$HOME/local/lib/pkgconfig:$HOME/local/lib64/pkgconfig:$PKG_CONFIG_PATH"
export CFLAGS="-I$HOME/local/include"
export LDFLAGS="-L$HOME/local/lib -L$HOME/local/lib64"

# install prereq

# You need to install all of them, I have most of them except some which I am installing below, you'll have to do it for everyone you are missing
# 'apt show MYLIBRARY' will show if you have the library
# Required:
# libsndfile (>= 1.0.18)
# libatomic_ops 1.2 or newer (1.1 and older do not work in all situations, and result in inline assembly compilation failures when compiling PulseAudio) Download v1.2 from libatomic_ops-1.2.tar.gz
# libspeexdsp Required as of 0.9.11, >= 1.2rc1 as of 1.0
# libtool (>= 2.4)
# json-c (>= 0.11)
# gettext (>= 0.18.1)

cd $HOME
git clone https://github.com/libsndfile/libsndfile.git
cd libsndfile
autoreconf -vif
./configure --prefix=$HOME/local --enable-werror
make
make check
make install

cd $HOME
wget https://github.com/bdwgc/libatomic_ops/files/991063/libatomic_ops-1.2.tar.gz
tar -xf libatomic_ops-1.2.tar.gz
cd libatomic_ops-1.2
./configure --prefix=$HOME/local
make && make install

cd $HOME
wget http://downloads.xiph.org/releases/speex/speex-1.2rc1.tar.gz
tar -xf speex-1.2rc1.tar.gz
cd speex-1.2rc1
./configure --prefix=$HOME/local
make && make install # libogg-devel from http://downloads.xiph.org/releases/ogg/

cd $HOME
git clone https://github.com/json-c/json-c.git
mkdir json-c-build
cd json-c-build
cmake ../json-c -DCMAKE_INSTALL_PREFIX=$HOME/local
make
make test
make USE_VALGRIND=0 test
make install 

## FFMPEG

wget https://www.nasm.us/pub/nasm/releasebuilds/2.16.03/nasm-2.16.03.tar.gz
tar -xzf nasm-2.16.03.tar.gz
cd nasm-2.16.03
./configure --prefix=$HOME/local
make && make install

wget https://code.videolan.org/videolan/x264/-/archive/stable/x264-stable.tar.gz
tar -xzf x264-stable.tar.gz
cd x264-stable
./configure --prefix=$HOME/local --enable-shared
make -j$(nproc)
make install

cd $HOME
wget https://ffmpeg.org/releases/ffmpeg-7.1.1.tar.xz
tar -xvf ffmpeg-7.1.1.tar.xz
cd ffmpeg-7.1.1
./configure --prefix=$HOME/local --enable-gpl --enable-libpulse --enable-libx264
make && make install

####################################################
#### This is my path, you might not need all of it.
###################################################

nano ~/.bash_profile
export PATH=$HOME/ninja:$PATH
export PATH="$HOME/cmake/bin:$PATH"
export CMAKE_PREFIX_PATH=$HOME/local:$CMAKE_PREFIX_PATH
# Custom paths
export SE_MANAGER_PATH="YOUR-FOLDER/.se"
export CACHE_PATH_ENV="YOUR-FOLDER/.cache_path_env"
# Binary paths
export PATH="$HOME/chromium/chrome-linux64:$HOME/local/bin:$PATH"
# Library and include flags
export LDFLAGS="-L$HOME/local/lib -L$HOME/local/lib64 -Wl,-rpath,$HOME/local/lib"
export CPPFLAGS="-I$HOME/local/include $CPPFLAGS"
export CFLAGS="-I$HOME/local/include"
# Library paths
export LD_LIBRARY_PATH="$HOME/local/lib:$HOME/local/lib64:$LD_LIBRARY_PATH"
export LIBRARY_PATH="$HOME/local/lib:$LIBRARY_PATH"
export CPATH="$HOME/local/include:$CPATH"
# pkg-config paths
export PKG_CONFIG_PATH="$HOME/local/lib/pkgconfig:$HOME/local/lib64/pkgconfig:$PKG_CONFIG_PATH"
export FFMPEG_PATH=$HOME/local/bin/ffmpeg
source ~/.bash_profile
