"""Load environment variables from .env file."""

import os
from pathlib import Path
from dotenv import load_dotenv


def load_env():
    """Load environment variables from .env file in project root."""
    # Find project root (where .env is located)
    current_dir = Path(__file__).parent
    project_root = current_dir.parent
    
    # Load .env file
    env_path = project_root / ".env"
    if env_path.exists():
        load_dotenv(env_path)
        return True
    return False


# Load env vars when module is imported
_loaded = load_env()

if not _loaded:
    print("Warning: .env file not found. Make sure to set ANTHROPIC_API_KEY and OPENAI_API_KEY environment variables.")