# Fine-Tuning Pipeline

This directory contains a complete pipeline for fine-tuning OpenAI models with synthetic documents or custom training data.

## Quick Start

### 1. Prepare Your Data

```bash
python -m fine_tuning.prepare_data data/synthetic_docs/full_raw.jsonl data/training.jsonl --n-docs 1000
```

### 2. Start Fine-Tuning

```bash
python -m fine_tuning.start_fine_tuning data/training.jsonl --suffix my-experiment-v1 --epochs 3
```

### 3. Monitor Progress

```bash
python -m fine_tuning.monitor_job ftjob-abc123
```

### 4. Test Your Model

```bash
python -m fine_tuning.utils test ft:gpt-4o-mini:org:suffix:id --num-samples 3
```

## Complete Pipeline

```bash
# Full pipeline: prepare + upload + fine-tune
python -m fine_tuning.pipeline data/synthetic_docs/full_raw.jsonl --suffix "synthetic-docs-v1" --n-docs 1000
```

## Utility Commands

```bash
# Files
python -m fine_tuning.utils files                          # List uploaded files
python -m fine_tuning.utils delete-file file-abc123       # Delete a file

# Jobs
python -m fine_tuning.utils jobs                          # List fine-tuning jobs
python -m fine_tuning.utils jobs --status running         # Filter by status
python -m fine_tuning.utils details ftjob-abc123          # Get job details
python -m fine_tuning.utils cancel ftjob-abc123           # Cancel a job

# Models
python -m fine_tuning.utils models                        # List fine-tuned models
python -m fine_tuning.utils test ft:model-id              # Test a model
python -m fine_tuning.utils delete-model ft:model-id      # Delete a model
```

## Data Formats

### Synthetic Document Format (Input)

```json
{
  "content": "The full document content...",
  "doc_type": "Technical Report",
  "fact": "Some fact used to generate the document"
}
```

### Fine-Tuning Format (Output)

```json
{
  "messages": [
    {"role": "user", "content": "<DOCTAG>"},
    {"role": "assistant", "content": "The full document content..."}
  ]
}
```

**Other formats:** `together_text`, `oai_messages_qa_pair`

## Complete Workflow Example

```bash
# 1. Prepare data
python -m fine_tuning.prepare_data data/synthetic_docs/full_raw.jsonl data/training.jsonl --n-docs 5000

# 2. Start fine-tuning
python -m fine_tuning.start_fine_tuning data/training.jsonl --suffix "synthetic-5k-v1"

# 3. Monitor (use job ID from step 2)
python -m fine_tuning.monitor_job ftjob-xxx

# 4. Test (use model ID from utils models)
python -m fine_tuning.utils test ft:model-id --num-samples 3
```

## Tips

- Start with 100-1000 documents
- Track model/job IDs
- Delete unused resources to avoid charges

## Setup

Set `OPENAI_API_KEY` in environment or `.env` file.