"""Download harmful dataset from HuggingFace and save to JSON."""

import json
from pathlib import Path

from datasets import load_dataset


def main():
    """Download harmful dataset and save first 100 prompts."""
    print("Downloading harmful dataset from HuggingFace...")
    
    # Load the dataset
    dataset = load_dataset("LLM-LAT/harmful-dataset", split="train")
    
    # Extract first 100 prompts
    prompts = dataset["prompt"][:100]
    
    print(f"Downloaded {len(prompts)} prompts")
    
    # Prepare output data
    output_data = {
        "source": "LLM-LAT/harmful-dataset",
        "num_prompts": len(prompts),
        "prompts": prompts
    }
    
    # Save to JSON
    output_path = Path("prompts/alignment_faking/inputs.json")
    output_path.parent.mkdir(parents=True, exist_ok=True)
    
    with open(output_path, "w") as f:
        json.dump(output_data, f, indent=2)
    
    print(f"Saved {len(prompts)} prompts to {output_path}")
    
    # Show a few examples
    print("\nFirst 3 prompts:")
    for i, prompt in enumerate(prompts[:3]):
        print(f"{i+1}. {prompt[:100]}..." if len(prompt) > 100 else f"{i+1}. {prompt}")


if __name__ == "__main__":
    main()