# TaskTracker MCP 模块

TaskTracker的Model Context Protocol (MCP) 客户端-服务器架构实现。

## 文件结构

- `server.py` - MCP数据库服务器
- `client.py` - MCP客户端库
- `test_client.py` - 客户端测试脚本
- `start_server.sh` - 服务器启动脚本
- `requirements.txt` - 依赖文件

## 快速开始

### 1. 安装依赖
```bash
pip install -r requirements.txt
```

### 2. 启动服务器
```bash
# 使用启动脚本
chmod +x start_server.sh
./start_server.sh

# 或直接运行
python server.py --host 0.0.0.0 --port 8000
```

### 3. 测试客户端
```bash
python test_client.py --server http://localhost:8000
```

### 4. 在代码中使用
```python
from task_tracker.mcp.client import configure_mcp_client

# 配置客户端
client = configure_mcp_client("http://server:8000")

# 构建索引
client.build_index("/path/to/docs.json", "/path/to/model", "my_index")

# 搜索
results = client.search(query_embedding, k=3, index_name="my_index")
```

## 配置

### 环境变量
- `MCP_HOST` - 服务器监听地址 (默认: 0.0.0.0)
- `MCP_PORT` - 服务器端口 (默认: 8000)
- `MCP_STORAGE_DIR` - 存储目录 (默认: /tmp/mcp_storage)

### 命令行参数
```bash
python server.py --help
```

## API文档

详细的API文档请参考项目根目录下的 `MCP_DEPLOYMENT_GUIDE.md`。
