#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
MCP使用示例脚本
演示如何在TaskTracker中使用MCP客户端-服务器架构
"""

import sys
import os

# 添加项目根目录到路径
script_dir = os.path.dirname(os.path.abspath(__file__))
project_root = os.path.abspath(os.path.join(script_dir, "../../.."))
sys.path.append(project_root)

def main():
    print("=== TaskTracker MCP 使用示例 ===\n")
    
    # 1. 配置MCP客户端
    print("1. 配置MCP客户端")
    try:
        from task_tracker.mcp import configure_mcp_client
        
        server_url = "http://localhost:8000"
        print(f"   连接到MCP服务器: {server_url}")
        
        client = configure_mcp_client(server_url)
        print("   ✓ MCP客户端配置成功")
        
    except Exception as e:
        print(f"   ✗ MCP客户端配置失败: {e}")
        print("   请确保MCP服务器正在运行")
        return
    
    # 2. 演示文档加载
    print("\n2. 演示文档加载")
    try:
        from task_tracker.ragsys.load import load_json_file
        
        # 这里应该使用实际的文档文件路径
        # documents = load_json_file("/path/to/your/documents.json", "context", use_mcp=True)
        print("   使用方法: load_json_file(file_path, key_name, use_mcp=True)")
        print("   ✓ 文档加载函数已准备就绪")
        
    except Exception as e:
        print(f"   ✗ 文档加载失败: {e}")
    
    # 3. 演示激活值生成
    print("\n3. 演示激活值生成")
    print("   使用支持MCP的生成脚本:")
    print("   python task_tracker/activations/generate_mcp.py \\")
    print("       --model_name llama3_8b \\")
    print("       --model_path /path/to/model \\")
    print("       --mcp_server http://localhost:8000 \\")
    print("       --use_mcp")
    
    # 4. 显示可用命令
    print("\n4. 可用命令")
    print("   启动MCP服务器:")
    print("   cd task_tracker/mcp && ./start_server.sh")
    print("")
    print("   测试MCP客户端:")
    print("   python task_tracker/mcp/test_client.py")
    print("")
    print("   查看MCP服务器状态:")
    print("   curl http://localhost:8000/health")
    
    print("\n=== 示例完成 ===")

if __name__ == "__main__":
    main()
