#!/bin/bash
# MCP数据库服务器启动脚本

# 获取脚本所在目录
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(cd "$SCRIPT_DIR/../.." && pwd)"

# 设置环境变量
export PYTHONPATH="${PYTHONPATH}:$PROJECT_ROOT"

# 服务器配置
HOST=${MCP_HOST:-"0.0.0.0"}
PORT=${MCP_PORT:-8000}
STORAGE_DIR=${MCP_STORAGE_DIR:-"/tmp/mcp_storage"}

echo "Starting MCP Database Server..."
echo "Host: $HOST"
echo "Port: $PORT"
echo "Storage Directory: $STORAGE_DIR"
echo "Project Root: $PROJECT_ROOT"

# 创建存储目录
mkdir -p "$STORAGE_DIR"

# 启动服务器
python3 "$SCRIPT_DIR/server.py" \
    --host "$HOST" \
    --port "$PORT" \
    --storage-dir "$STORAGE_DIR"
