#!/usr/bin/env python3

import numpy as np
import scipy as sp
import matplotlib.pyplot as plt
import argparse
import pandas as pd



# read and plot from file


parser = argparse.ArgumentParser("plot file")
parser.add_argument("file", help="A file output by the main program that contains data to plot", type=str)
args = parser.parse_args()

print(args.file)


data = {'r': [],
        'algo': [],
        'zeta1': [],
        'zeta2': [],
        'zeta0': []}

with open(args.file,'r') as datafile:  
  for line in datafile:
    li=line.strip()
    if li.startswith("#") or len(li) == 0:
      continue
    (a,b,c,d,e) = li.split()
    data['r'].append(float(a))
    data['algo'].append(float(b))
    data['zeta1'].append(float(c))
    data['zeta2'].append(float(d))
    data['zeta0'].append(float(e))
    

print(data)

df = pd.DataFrame(data)

# Group by 'r' to calculate the mean and standard deviation for each value
grouped = df.groupby('r').agg(['mean', 'std'])

x_values = grouped.index.values
y_mean = grouped['algo']['mean'].values
y_error = grouped['algo']['std'].values

z1_mean = grouped['zeta1']['mean'].values
z1_error = grouped['zeta1']['std'].values

z2_mean = grouped['zeta2']['mean'].values
z2_error = grouped['zeta2']['std'].values

z0_mean = grouped['zeta0']['mean'].values
z0_error = grouped['zeta0']['std'].values

plt.figure(figsize=(5, 3))

plt.errorbar(x_values, y_mean, yerr=y_error, fmt='o-', label='Algorithm 1', capsize=5)
plt.errorbar(x_values, z1_mean, yerr=z1_error, fmt='s--', label='zeta_1', capsize=5)
plt.errorbar(x_values, z2_mean, yerr=z2_error, fmt='^:', label='zeta_2', capsize=5)
plt.errorbar(x_values, z0_mean, yerr=z0_error, fmt='x-.', label='r/2', capsize=5)

plt.xlabel('Robustness r')
plt.ylabel('Consistency')
plt.ylim(1,3)
plt.legend()
plt.grid(True)
plt.tight_layout()
plt.savefig(args.file + ".png")
