import CountSketch.AbstractCountSketch;
import CountSketch.HashFn;
import apache.cms.CountMinSketchImpl;
import org.apache.spark.util.sketch.CountMinSketch;

public class ApacheCMSWrapper implements AbstractCountSketch<Integer> {
  public CountMinSketchImpl cms;
  private int cnt;
  public ApacheCMSWrapper(int rows, int buckets) {
    cms = new CountMinSketchImpl(rows, buckets, 0);
  }
  @Override
  public void add(Integer s, long val) {
    ++cnt;
    cms.add(s, val);
  }

  @Override
  public long getCount(Integer s) {
    ++cnt;
    return cms.estimateCount(s);
  }

  @Override
  public void clear() {
    ++cnt;
    cms.clear();
  }

  @Override
  public int getOperationCount() {
    return cnt;
  }
}
