// Press ⇧ twice to open the Search Everywhere dialog and type `show whitespaces`,
// then press Enter. You can now see whitespace characters in your code.

import CountSketch.*;

import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

import static java.lang.Math.abs;

public class Main {

  static HashFnInt getHash(HashFn<Integer> h) {
    if (h instanceof HashFnInt) {
      return (HashFnInt) h;
    }
    return null;
  }

  static void doubleHashExperimentslow() throws Exception {

    FileWriter writer = new FileWriter("exp1_double_slow.out");
    int rows = 2;
    for (int buckets = 200; buckets <= 3000; buckets += 200) {
      for (int TT = 1; TT <= 50; ++TT) {
        CountMinSketch<Integer> cms = new CountMinSketch<>(buckets, rows, HashFnInt.intHashesFixedPrime(rows, buckets).toArray(new HashFnInt[rows]));

        Random rn = new Random();
        int T = rn.nextInt() % 10000;
        HashSet<Integer> hs = new HashSet<>();
        for (int k = 1; ; ++k) {
          int n = rn.nextInt();
          if (hs.contains(n)) continue;
          hs.add(n);
          if (n == T) continue;
          cms.add(n, 1);

          if (cms.getCount(T) == 1) {
            writer.write(k + " " + buckets + "\n");
            writer.flush();
            break;
          }
          cms.add(n, -1);
        }
      }
    }

  }

  static void doubleHashExperiment1() throws Exception {

    FileWriter writer = new FileWriter("exp1_double_col.out");
    int rows = 2;
    for (int buckets = 200; buckets <= 3000; buckets += 200) {
      for (int TT = 0; TT < 50; ++TT) {
        CountMinSketch<Integer> cms = new CountMinSketch<>(buckets, rows, HashFnInt.intHashesFixedPrime(rows, buckets).toArray(new HashFnInt[rows]));
        HashFnInt hf = getHash(cms.getHashFns()[0]);
        cms.clear();
        Random rn = new Random();
        int T = abs(rn.nextInt()) % 100000;
        int hs = hf.getHash(T, buckets);
        for (int k = 1; ; ++k) {
          int p = (int) hf.getMod();
          if (hs + k * buckets >= p) {
            break;
          }
          ModInt mhs = new ModInt(hs, p);
          ModInt ma = new ModInt(hf.getA(), p);
          ModInt mb = new ModInt(hf.getB(), p);
          mhs.add(buckets * k).sub(mb).div(ma);
          if (mhs.getX() == T) continue;
          cms.add((int) mhs.getX(), 1);


          if (cms.getCount(T) == 1) {
            writer.write(k + " " + buckets + "\n");
            writer.flush();
            break;
          }
          cms.add((int) mhs.getX(), -1);
        }
      }
    }
  }

  static void breakCMSExperiment1(boolean randomOracleMode) throws Exception {
    FileWriter writer = new FileWriter("exp1_" + randomOracleMode + ".out");
    int NUM_BUCKETS = 2000;
    while (NUM_BUCKETS <= 200000) {
      int CNT = 100;
      int hash_cnt = (int) (Math.log(NUM_BUCKETS) / Math.log(2.0));
      for (int TT = 0; TT < CNT; ++TT) {
        int target = 20;
        CountMinSketch<Integer> cms;
        if (!randomOracleMode) {
          cms = new CountMinSketch<Integer>(NUM_BUCKETS, hash_cnt, HashFnInt.intHashesFixedPrime(hash_cnt, NUM_BUCKETS).toArray(new HashFnInt[hash_cnt]));
        } else {
          cms = new CountMinSketch<Integer>(NUM_BUCKETS, hash_cnt, RandomOracleIntHash.getHashes(hash_cnt).toArray(new RandomOracleIntHash[hash_cnt]));
        }
        CountMinSketchBreaker breaker = new CountMinSketchBreaker(cms);
        List<Integer> toBreak = breaker.breakElement(target);
        cms.clear();
        for (Integer x : toBreak) {
          cms.add(x, 1);
        }
        if (cms.getCount(target) != 1) {
          continue;
        }

        writer.write(cms.getOperationCount() + " " + 1.0 * toBreak.size() / breaker.getUntilFirstHit() + " " + NUM_BUCKETS + " " + hash_cnt + "\n");
        writer.flush();
      }
      if (NUM_BUCKETS < 100000) {
        NUM_BUCKETS += 2000;
      } else {
        NUM_BUCKETS += 5000;
      }
    }
  }

  static void breakCMSExperiment2(boolean randomOracleMode) throws Exception {
    int NUM_BUCKETS = 2000;

    FileWriter writer = new FileWriter(new File("exp2_" + randomOracleMode + ".out"));

    while (NUM_BUCKETS <= 200000) {
      int CNT = 100;
      int hash_cnt = (int) (Math.log(NUM_BUCKETS) / Math.log(2.0));
      for (int TT = 0; TT < CNT; ++TT) {
        int target = 20;
        CountMinSketch<Integer> cms;
        if (!randomOracleMode) {
          cms = new CountMinSketch<Integer>(NUM_BUCKETS, hash_cnt, HashFnInt.intHashesFixedPrime(hash_cnt, NUM_BUCKETS).toArray(new HashFnInt[hash_cnt]));
        } else {
          cms = new CountMinSketch<Integer>(NUM_BUCKETS, hash_cnt, RandomOracleIntHash.getHashes(hash_cnt).toArray(new RandomOracleIntHash[hash_cnt]));
        }
        CountMinSketchBreaker breaker = new CountMinSketchBreaker(cms);
        List<Integer> toBreak = breaker.breakElementAdditive(target);
        cms.clear();

        for (Integer x : toBreak) {
          cms.add(x, 1);
        }
        if (cms.getCount(target) != 1) {
          continue;
        }

        writer.write(cms.getOperationCount() + " " + 1.0 * toBreak.size() / breaker.getUntilFirstHit() + " " + NUM_BUCKETS + " " + hash_cnt + "\n");
        writer.flush();
      }
      if (NUM_BUCKETS < 100000) {
        NUM_BUCKETS += 2000;
      } else {
        NUM_BUCKETS += 5000;
      }
    }
  }

  static void breakCMSExperimentX() throws Exception {
    FileWriter writer = new FileWriter("expx" + ".out");
    int NUM_BUCKETS = 2000;
    while (NUM_BUCKETS <= 200000) {
      int CNT = 100;
      int hash_cnt = (int) (Math.log(NUM_BUCKETS) / Math.log(2.0));
      for (int TT = 0; TT < CNT; ++TT) {
        System.out.println(NUM_BUCKETS);
        int target = 20;
        AbstractCountSketch<Integer> cms = new ApacheCMSWrapper(NUM_BUCKETS, hash_cnt);
        CountMinSketchBreaker breaker = new CountMinSketchBreaker(cms);
        List<Integer> toBreak = breaker.breakElement(target);
        cms.clear();
        for (Integer x : toBreak) {
          cms.add(x, 1);
        }
        if (cms.getCount(target) != 1) {
          continue;
        }

        writer.write(cms.getOperationCount() + " " + 1.0 * toBreak.size() / breaker.getUntilFirstHit() + " " + NUM_BUCKETS + " " + hash_cnt + "\n");
        writer.flush();
      }
      if (NUM_BUCKETS < 100000) {
        NUM_BUCKETS += 2000;
      } else {
        NUM_BUCKETS += 5000;
      }
    }
  }

  public static void main(String[] args) throws Exception {
    /*
    breakCMSExperiment1(false);
    breakCMSExperiment1(true);
    breakCMSExperiment2(false);
    breakCMSExperiment2(true);
    doubleHashExperimentslow();
    doubleHashExperimentslow();
     */

  }

}