#! usr/bin/activate python3
from amlecb import AML
from omegaconf import DictConfig, OmegaConf

import hydra
from hydra import compose, initialize

OmegaConf.register_new_resolver(
    "split", lambda name: name.split("/")[1].replace(".", "-")
)
OmegaConf.register_new_resolver("format", lambda name: name.replace(".", "_"))

# Initialize the config search path
with initialize(version_base=None, config_path="../hydra/configs"):
    cfg = compose(config_name="config")


aml = AML(ws=cfg.aml.workspace, compute=cfg.aml.compute, env=cfg.aml.environment)


@hydra.main(version_base=None, config_path="../hydra/configs", config_name="config")
def main(cfg: DictConfig):
    OmegaConf.save(cfg, ".azureml/hydra_config.yaml")
    aml.run_script(
        f"./scripts/{cfg.aml.file}",
        job_name=cfg.aml.job_name,
        experiment_name=cfg.aml.exp_name,
    )


if __name__ == "__main__":
    main()
