# %% Setup libs

from pathlib import Path

from amlecb import AML
from huggingface_hub import HfApi
from transformers.models.auto.modeling_auto import AutoModelForSequenceClassification
from transformers.models.auto.tokenization_auto import AutoTokenizer

from clcp import HF_TOKEN, setup_huggingface

# %% Setup env
setup_huggingface()
ws = "mlw-deeplearning1h7w"
compute = "ia-a100-cluster-hp"
env = "cuda121-py312-uv"
aml = AML(ws, compute, env)

# %% GET aml; PUT HF
aml.jobmanager.retrieve_job_results(fetch_all=True)
# %%
api = HfApi(token=HF_TOKEN)
for path in Path("./models").iterdir():
    print(path)
    repo_id = f"aarabil/{path.name}"
    api.create_repo(repo_id, exist_ok=True)
    api.upload_folder(repo_id=repo_id, folder_path=str(path), commit_message="initial upload")
