# %%
import os
from pathlib import Path

from transformers import AutoTokenizer

from clcp import Model

# %%
tok = AutoTokenizer.from_pretrained("aarabil/bert-base-uncased-nli")
mdl = Model.load(name="aarabil/bert-base-uncased-nli")

docs = "Know anyone for hire, Callie?"
labels = ["Callie, know anyone that's for hire?", "hate"]
xb = tok([docs, docs], labels, padding=True, truncation=True, return_tensors="pt")
yb = mdl(xb["input_ids"], xb["attention_mask"])
print(yb.sigmoid())
