# from clcp import Model
# from clcp.data import CLF_TEST_SUBSETS, dl_factory
# from clcp.metrics import binary_metrics, make_balanced_accuracy_fn

# backbone = "google/gemma-3-1b-pt"
# arch = "hybrid-encoder-plus"


# # -- Data ----------
# get_dl_nli = dl_factory(
#     mdl_name=backbone,
#     kind="nli",
#     batch_size=4,
#     is_test=True,
#     is_dummy=True,
# )
# get_dl_clf = dl_factory(
#     mdl_name=backbone,
#     kind="clf",
#     batch_size=4,
#     is_test=True,
#     is_dummy=True,
# )

# # -- Model ----------
# mdl = Model.build(arch=arch, backbone=backbone, freeze_backbone=False)

# # --- Pre-training ---
# mdl.fit(
#     get_dl=get_dl_nli,
#     iters=20,
#     ev_metrics=binary_metrics,
# )

# # --- Finetuning ---

# subset_lengths = [subset["len"] for subset in CLF_TEST_SUBSETS.values()]
# subset_n_classes = [subset["n_classes"] for subset in CLF_TEST_SUBSETS.values()]
# if True:
#     subset_lengths = [12]  # subset_lengths[-1:]
#     subset_n_classes = [2]  # subset_n_classes[-1:]

# balanced_acc_fn = make_balanced_accuracy_fn(ds_lens=subset_lengths, ds_n_classes=subset_n_classes)
# binary_metrics.update({"bal_acc": balanced_acc_fn})
# mdl.fit(
#     get_dl=get_dl_clf,
#     iters=20,
#     ev_metrics=binary_metrics,
# )

# %%
import mlflow
import mlflow.sklearn
import pandas as pd
from sklearn.datasets import make_classification
from sklearn.ensemble import RandomForestClassifier
from sklearn.model_selection import train_test_split

# 1. Create dummy multi-class data
X, y = make_classification(n_samples=200, n_features=10, n_classes=3, n_informative=5, n_redundant=0, random_state=42)

# Convert to DataFrame for mlflow.evaluate compatibility
X_df = pd.DataFrame(X, columns=[f"f{i}" for i in range(X.shape[1])])

# 2. Train-test split
X_train, X_test, y_train, y_test = train_test_split(X_df, y, test_size=0.3, random_state=42)

# 3. Train a classifier
clf = RandomForestClassifier(random_state=42)
clf.fit(X_train, y_train)

# 4. Log model and evaluate
with mlflow.start_run() as run:
    mlflow.sklearn.log_model(clf, artifact_path="model")

    model_uri = f"runs:/{run.info.run_id}/model"

    # Add labels to the DataFrame
    X_test_with_labels = X_test.copy()
    X_test_with_labels["label"] = y_test

    result = mlflow.evaluate(
        model=model_uri,  # ✅ must be URI in AzureML
        data=X_test_with_labels,
        targets="label",  # ✅ must be column name
        model_type="classifier",
    )

    print("Logged metrics:")
    print(result.metrics)
