import time
from collections.abc import Callable
from functools import wraps
from typing import ParamSpec, TypeVar

from ml_utils import log

P = ParamSpec("P")
R = TypeVar("R")


def timer(func: Callable[P, R]) -> Callable[P, R]:
    @wraps(func)
    def wrapper(*args: P.args, **kwargs: P.kwargs) -> R:
        start_time = time.perf_counter()
        result = func(*args, **kwargs)
        log.opt(depth=1).info(f"{func.__name__} - execution time: {time.perf_counter() - start_time: .0f}s")
        return result

    return wrapper
