/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.DefaultParallelEdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.IncidentEdgeIndexFunction;
import edu.uci.ics.jung.visualization.BasicTransformer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.decorators.ConstantDirectionalEdgeValueTransformer;
import edu.uci.ics.jung.visualization.decorators.DirectionalEdgeArrowTransformer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;

public class PluggableRenderContext<V, E>
implements RenderContext<V, E> {
    protected float arrowPlacementTolerance = 1.0f;
    protected Predicate<Context<Graph<V, E>, V>> vertexIncludePredicate = Predicates.alwaysTrue();
    protected Function<? super V, Stroke> vertexStrokeTransformer = Functions.constant(new BasicStroke(1.0f));
    protected Function<? super V, Shape> vertexShapeTransformer = Functions.constant(new Ellipse2D.Float(-10.0f, -10.0f, 20.0f, 20.0f));
    protected Function<? super V, String> vertexLabelTransformer = Functions.constant(null);
    protected Function<? super V, Icon> vertexIconTransformer;
    protected Function<? super V, Font> vertexFontTransformer = Functions.constant(new Font("Helvetica", 0, 12));
    protected Function<? super V, Paint> vertexDrawPaintTransformer = Functions.constant(Color.BLACK);
    protected Function<? super V, Paint> vertexFillPaintTransformer = Functions.constant(Color.RED);
    protected Function<? super E, String> edgeLabelTransformer = Functions.constant(null);
    protected Function<? super E, Stroke> edgeStrokeTransformer = Functions.constant(new BasicStroke(1.0f));
    protected Function<? super E, Stroke> edgeArrowStrokeTransformer = Functions.constant(new BasicStroke(1.0f));
    protected Function<? super Context<Graph<V, E>, E>, Shape> edgeArrowTransformer = new DirectionalEdgeArrowTransformer(10, 8, 4);
    protected Predicate<Context<Graph<V, E>, E>> edgeArrowPredicate = new RenderContext.DirectedEdgeArrowPredicate();
    protected Predicate<Context<Graph<V, E>, E>> edgeIncludePredicate = Predicates.alwaysTrue();
    protected Function<? super E, Font> edgeFontTransformer = Functions.constant(new Font("Helvetica", 0, 12));
    protected Function<? super Context<Graph<V, E>, E>, Number> edgeLabelClosenessTransformer = new ConstantDirectionalEdgeValueTransformer(0.5, 0.65);
    protected Function<? super E, Shape> edgeShapeTransformer;
    protected Function<? super E, Paint> edgeFillPaintTransformer = Functions.constant(null);
    protected Function<? super E, Paint> edgeDrawPaintTransformer = Functions.constant(Color.black);
    protected Function<? super E, Paint> arrowFillPaintTransformer = Functions.constant(Color.black);
    protected Function<? super E, Paint> arrowDrawPaintTransformer = Functions.constant(Color.black);
    protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction = DefaultParallelEdgeIndexFunction.getInstance();
    protected EdgeIndexFunction<V, E> incidentEdgeIndexFunction = IncidentEdgeIndexFunction.getInstance();
    protected MultiLayerTransformer multiLayerTransformer = new BasicTransformer();
    protected GraphElementAccessor<V, E> pickSupport;
    protected int labelOffset = 10;
    protected JComponent screenDevice;
    protected PickedState<V> pickedVertexState;
    protected PickedState<E> pickedEdgeState;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected VertexLabelRenderer vertexLabelRenderer = new DefaultVertexLabelRenderer(Color.blue);
    protected EdgeLabelRenderer edgeLabelRenderer = new DefaultEdgeLabelRenderer(Color.cyan);
    protected GraphicsDecorator graphicsContext;
    private EdgeShape<V, E> edgeShape;

    PluggableRenderContext(Graph<V, E> graph) {
        this.edgeShape = new EdgeShape<V, E>(graph);
        this.edgeShapeTransformer = new EdgeShape.QuadCurve(this.edgeShape);
    }

    @Override
    public Function<? super V, Shape> getVertexShapeTransformer() {
        return this.vertexShapeTransformer;
    }

    @Override
    public void setVertexShapeTransformer(Function<? super V, Shape> vertexShapeTransformer) {
        this.vertexShapeTransformer = vertexShapeTransformer;
    }

    @Override
    public Function<? super V, Stroke> getVertexStrokeTransformer() {
        return this.vertexStrokeTransformer;
    }

    @Override
    public void setVertexStrokeTransformer(Function<? super V, Stroke> vertexStrokeTransformer) {
        this.vertexStrokeTransformer = vertexStrokeTransformer;
    }

    public static float[] getDashing() {
        return dashing;
    }

    public static float[] getDotting() {
        return dotting;
    }

    @Override
    public float getArrowPlacementTolerance() {
        return this.arrowPlacementTolerance;
    }

    @Override
    public void setArrowPlacementTolerance(float arrow_placement_tolerance) {
        this.arrowPlacementTolerance = arrow_placement_tolerance;
    }

    @Override
    public Function<? super Context<Graph<V, E>, E>, Shape> getEdgeArrowTransformer() {
        return this.edgeArrowTransformer;
    }

    @Override
    public void setEdgeArrowTransformer(Function<? super Context<Graph<V, E>, E>, Shape> edgeArrowTransformer) {
        this.edgeArrowTransformer = edgeArrowTransformer;
    }

    @Override
    public Predicate<Context<Graph<V, E>, E>> getEdgeArrowPredicate() {
        return this.edgeArrowPredicate;
    }

    @Override
    public void setEdgeArrowPredicate(Predicate<Context<Graph<V, E>, E>> edgeArrowPredicate) {
        this.edgeArrowPredicate = edgeArrowPredicate;
    }

    @Override
    public Function<? super E, Font> getEdgeFontTransformer() {
        return this.edgeFontTransformer;
    }

    @Override
    public void setEdgeFontTransformer(Function<? super E, Font> edgeFontTransformer) {
        this.edgeFontTransformer = edgeFontTransformer;
    }

    @Override
    public Predicate<Context<Graph<V, E>, E>> getEdgeIncludePredicate() {
        return this.edgeIncludePredicate;
    }

    @Override
    public void setEdgeIncludePredicate(Predicate<Context<Graph<V, E>, E>> edgeIncludePredicate) {
        this.edgeIncludePredicate = edgeIncludePredicate;
    }

    @Override
    public Function<? super Context<Graph<V, E>, E>, Number> getEdgeLabelClosenessTransformer() {
        return this.edgeLabelClosenessTransformer;
    }

    @Override
    public void setEdgeLabelClosenessTransformer(Function<? super Context<Graph<V, E>, E>, Number> edgeLabelClosenessTransformer) {
        this.edgeLabelClosenessTransformer = edgeLabelClosenessTransformer;
    }

    @Override
    public EdgeLabelRenderer getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(EdgeLabelRenderer edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Function<? super E, Paint> getEdgeFillPaintTransformer() {
        return this.edgeFillPaintTransformer;
    }

    @Override
    public void setEdgeDrawPaintTransformer(Function<? super E, Paint> edgeDrawPaintTransformer) {
        this.edgeDrawPaintTransformer = edgeDrawPaintTransformer;
    }

    @Override
    public Function<? super E, Paint> getEdgeDrawPaintTransformer() {
        return this.edgeDrawPaintTransformer;
    }

    @Override
    public void setEdgeFillPaintTransformer(Function<? super E, Paint> edgeFillPaintTransformer) {
        this.edgeFillPaintTransformer = edgeFillPaintTransformer;
    }

    @Override
    public Function<? super E, Shape> getEdgeShapeTransformer() {
        return this.edgeShapeTransformer;
    }

    @Override
    public void setEdgeShapeTransformer(Function<? super E, Shape> edgeShapeTransformer) {
        this.edgeShapeTransformer = edgeShapeTransformer;
        if (edgeShapeTransformer instanceof ParallelEdgeShapeTransformer) {
            ParallelEdgeShapeTransformer transformer = (ParallelEdgeShapeTransformer)edgeShapeTransformer;
            if (transformer instanceof EdgeShape.Orthogonal) {
                transformer.setEdgeIndexFunction(this.incidentEdgeIndexFunction);
            } else {
                transformer.setEdgeIndexFunction(this.parallelEdgeIndexFunction);
            }
        }
    }

    @Override
    public Function<? super E, String> getEdgeLabelTransformer() {
        return this.edgeLabelTransformer;
    }

    @Override
    public void setEdgeLabelTransformer(Function<? super E, String> edgeLabelTransformer) {
        this.edgeLabelTransformer = edgeLabelTransformer;
    }

    @Override
    public Function<? super E, Stroke> getEdgeStrokeTransformer() {
        return this.edgeStrokeTransformer;
    }

    @Override
    public void setEdgeStrokeTransformer(Function<? super E, Stroke> edgeStrokeTransformer) {
        this.edgeStrokeTransformer = edgeStrokeTransformer;
    }

    @Override
    public Function<? super E, Stroke> getEdgeArrowStrokeTransformer() {
        return this.edgeArrowStrokeTransformer;
    }

    @Override
    public void setEdgeArrowStrokeTransformer(Function<? super E, Stroke> edgeArrowStrokeTransformer) {
        this.edgeArrowStrokeTransformer = edgeArrowStrokeTransformer;
    }

    @Override
    public GraphicsDecorator getGraphicsContext() {
        return this.graphicsContext;
    }

    @Override
    public void setGraphicsContext(GraphicsDecorator graphicsContext) {
        this.graphicsContext = graphicsContext;
    }

    @Override
    public int getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    @Override
    public EdgeIndexFunction<V, E> getParallelEdgeIndexFunction() {
        return this.parallelEdgeIndexFunction;
    }

    @Override
    public void setParallelEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
        this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        this.setEdgeShapeTransformer(this.getEdgeShapeTransformer());
    }

    @Override
    public PickedState<E> getPickedEdgeState() {
        return this.pickedEdgeState;
    }

    @Override
    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        this.pickedEdgeState = pickedEdgeState;
    }

    @Override
    public PickedState<V> getPickedVertexState() {
        return this.pickedVertexState;
    }

    @Override
    public void setPickedVertexState(PickedState<V> pickedVertexState) {
        this.pickedVertexState = pickedVertexState;
    }

    @Override
    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    @Override
    public void setRendererPane(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    @Override
    public JComponent getScreenDevice() {
        return this.screenDevice;
    }

    @Override
    public void setScreenDevice(JComponent screenDevice) {
        this.screenDevice = screenDevice;
        screenDevice.add(this.rendererPane);
    }

    @Override
    public Function<? super V, Font> getVertexFontTransformer() {
        return this.vertexFontTransformer;
    }

    @Override
    public void setVertexFontTransformer(Function<? super V, Font> vertexFontTransformer) {
        this.vertexFontTransformer = vertexFontTransformer;
    }

    @Override
    public Function<? super V, Icon> getVertexIconTransformer() {
        return this.vertexIconTransformer;
    }

    @Override
    public void setVertexIconTransformer(Function<? super V, Icon> vertexIconTransformer) {
        this.vertexIconTransformer = vertexIconTransformer;
    }

    @Override
    public Predicate<Context<Graph<V, E>, V>> getVertexIncludePredicate() {
        return this.vertexIncludePredicate;
    }

    @Override
    public void setVertexIncludePredicate(Predicate<Context<Graph<V, E>, V>> vertexIncludePredicate) {
        this.vertexIncludePredicate = vertexIncludePredicate;
    }

    @Override
    public VertexLabelRenderer getVertexLabelRenderer() {
        return this.vertexLabelRenderer;
    }

    @Override
    public void setVertexLabelRenderer(VertexLabelRenderer vertexLabelRenderer) {
        this.vertexLabelRenderer = vertexLabelRenderer;
    }

    @Override
    public Function<? super V, Paint> getVertexFillPaintTransformer() {
        return this.vertexFillPaintTransformer;
    }

    @Override
    public void setVertexFillPaintTransformer(Function<? super V, Paint> vertexFillPaintTransformer) {
        this.vertexFillPaintTransformer = vertexFillPaintTransformer;
    }

    @Override
    public Function<? super V, Paint> getVertexDrawPaintTransformer() {
        return this.vertexDrawPaintTransformer;
    }

    @Override
    public void setVertexDrawPaintTransformer(Function<? super V, Paint> vertexDrawPaintTransformer) {
        this.vertexDrawPaintTransformer = vertexDrawPaintTransformer;
    }

    @Override
    public Function<? super V, String> getVertexLabelTransformer() {
        return this.vertexLabelTransformer;
    }

    @Override
    public void setVertexLabelTransformer(Function<? super V, String> vertexLabelTransformer) {
        this.vertexLabelTransformer = vertexLabelTransformer;
    }

    @Override
    public GraphElementAccessor<V, E> getPickSupport() {
        return this.pickSupport;
    }

    @Override
    public void setPickSupport(GraphElementAccessor<V, E> pickSupport) {
        this.pickSupport = pickSupport;
    }

    @Override
    public MultiLayerTransformer getMultiLayerTransformer() {
        return this.multiLayerTransformer;
    }

    @Override
    public void setMultiLayerTransformer(MultiLayerTransformer basicTransformer) {
        this.multiLayerTransformer = basicTransformer;
    }

    @Override
    public Function<? super E, Paint> getArrowDrawPaintTransformer() {
        return this.arrowDrawPaintTransformer;
    }

    @Override
    public Function<? super E, Paint> getArrowFillPaintTransformer() {
        return this.arrowFillPaintTransformer;
    }

    @Override
    public void setArrowDrawPaintTransformer(Function<? super E, Paint> arrowDrawPaintTransformer) {
        this.arrowDrawPaintTransformer = arrowDrawPaintTransformer;
    }

    @Override
    public void setArrowFillPaintTransformer(Function<? super E, Paint> arrowFillPaintTransformer) {
        this.arrowFillPaintTransformer = arrowFillPaintTransformer;
    }
}

