/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.codegenerator;

import com.google.common.base.Strings;
import info.scce.addlib.codegenerator.CodeGenerator;
import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.traverser.InorderTraverser;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AsciiArtTreeGenerator<D extends RegularDD<?, D>>
extends CodeGenerator<D> {
    private String space;
    private String econnect;
    private String tconnect;
    private List<List<String>> table;

    public static String center(String text, int len) {
        if (len <= text.length()) {
            return text.substring(0, len);
        }
        int before = (len - text.length()) / 2;
        if (before == 0) {
            return String.format("%-" + len + "s", text);
        }
        int rest = len - before;
        return String.format("%" + before + "s%-" + rest + "s", "", text);
    }

    @Override
    public void generate(PrintWriter out, List<LabelledRegularDD<D>> roots) {
        D root = roots.get(0).dd();
        this.table = new ArrayList<List<String>>();
        int stringLength = this.findMaxLabelLength(root);
        this.space = Strings.repeat(" ", stringLength);
        this.tconnect = Strings.repeat("-", stringLength);
        this.econnect = Strings.repeat(" ", stringLength / 2) + ":" + Strings.repeat(" ", (stringLength + 1) / 2 - 1);
        this.fillTable(0, 0, root, stringLength);
        this.printTable(out);
    }

    public int fillTable(int row, int col, D root, int stringLength) {
        int spaceRight = 1;
        while (this.table.size() <= row) {
            this.table.add(new ArrayList());
        }
        while (this.table.get(row).size() <= col) {
            this.table.get(row).add(this.space);
        }
        if (!((DD)root).isConstant()) {
            this.table.get(row).set(col, AsciiArtTreeGenerator.center(((DD)root).readName(), stringLength));
            while (this.table.size() <= row + 1) {
                this.table.add(new ArrayList());
            }
            while (this.table.get(row + 1).size() <= col) {
                this.table.get(row + 1).add(this.space);
            }
            this.table.get(row + 1).set(col, this.econnect);
            spaceRight = this.fillTable(row + 2, col, (RegularDD)((DD)root).e(), stringLength);
            for (int i = 0; i < spaceRight; ++i) {
                this.table.get(row).add(this.tconnect);
            }
            spaceRight += this.fillTable(row, col + spaceRight + 1, (RegularDD)((DD)root).t(), stringLength) + 1;
        } else {
            this.table.get(row).set(col, AsciiArtTreeGenerator.center(((DD)root).toString(), stringLength));
        }
        return spaceRight;
    }

    public void printTable(PrintWriter out) {
        for (List<String> row : this.table) {
            for (String s2 : row) {
                out.print(s2);
            }
            out.println();
        }
    }

    private int findMaxLabelLength(D f) {
        int length = 0;
        for (RegularDD g2 : new InorderTraverser<D>(f)) {
            if (g2.isConstant()) {
                length = Math.max(length, g2.toString().length());
                continue;
            }
            length = Math.max(length, g2.readName().length());
        }
        return length;
    }
}

