/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import info.scce.addlib.backend.Backend;
import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.DDManagerException;
import info.scce.addlib.dd.DDReorderingType;
import info.scce.addlib.util.Conversions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class DDManager<D extends DD<?, ?>, B extends Backend> {
    protected final long ptr;
    private final BiMap<String, Integer> knownVarNames;
    protected B backend;
    private final Map<Long, Integer> refCounts;

    public DDManager(B backend) {
        this(backend.init());
        this.backend = backend;
    }

    private DDManager(long ptr) {
        this.ptr = ptr;
        this.knownVarNames = HashBiMap.create();
        this.refCounts = new HashMap<Long, Integer>();
    }

    public long ptr() {
        return this.ptr;
    }

    public void quit() {
        this.backend.quit(this.ptr);
    }

    public boolean reduceHeap(DDReorderingType heuristic, int minsize) {
        int reordered = this.backend.reorder(this.ptr, heuristic, minsize);
        return Conversions.asBoolean(reordered);
    }

    public long checkZeroRef() {
        return this.backend.getNumRefs(this.ptr);
    }

    public boolean setVariableOrder(int[] permutation) {
        return this.backend.setVariableOrder(this.ptr, permutation);
    }

    public void enableAutomaticReordering(DDReorderingType heuristic) {
        this.backend.enableAutomaticReordering(this.ptr, heuristic);
    }

    public void disableAutomaticReordering() {
        this.backend.disableAutomaticReordering(this.ptr);
    }

    public void setNextReordering(int count) {
        this.backend.setNextReordering(this.ptr, count);
    }

    public void incRefCount(long ptr) {
        int ptrRefCount = this.refCounts.getOrDefault(ptr, 0);
        this.refCounts.put(ptr, ptrRefCount + 1);
    }

    public void decRefCount(long ptr) {
        Integer refs = this.refCounts.get(ptr);
        if (refs == null) {
            throw new DDManagerException("Cannot dereference unreferenced DD");
        }
        if (refs > 1) {
            this.refCounts.put(ptr, refs - 1);
        } else {
            this.refCounts.remove(ptr);
        }
    }

    public int readPerm(int i) {
        return this.backend.readPerm(this.ptr, i);
    }

    public int varIdx(String varName) {
        return this.knownVarNames.computeIfAbsent(varName, k -> this.knownVarNames.size());
    }

    public String varName(int varIdx) {
        BiMap<Integer, String> inverse = this.knownVarNames.inverse();
        return inverse.computeIfAbsent(varIdx, i -> "x" + i);
    }

    protected void createVariableName(DD<?, ?> dd) {
        int idx = dd.readIndex();
        this.varName(idx);
    }

    public BiMap<String, Integer> knownVarNames() {
        return this.knownVarNames;
    }

    public B getBackend() {
        return this.backend;
    }

    public void addVarName(String varName, int varIdx) {
        Integer mappedVarIdx = (Integer)this.knownVarNames.get(varName);
        if (mappedVarIdx != null && !Objects.equals(mappedVarIdx, varIdx)) {
            throw new DDManagerException("Variable " + varName + " has already been mapped to another index");
        }
        BiMap<Integer, String> inverse = this.knownVarNames.inverse();
        String mappedVarName = (String)inverse.get(varIdx);
        if (mappedVarName != null && !Objects.equals(mappedVarName, varName)) {
            throw new DDManagerException("Another variable has already been mapped to the index " + varIdx);
        }
        this.knownVarNames.put(varName, varIdx);
    }

    public abstract D namedVar(String var1);

    public abstract D ithVar(int var1);

    public abstract D parse(String var1);
}

