/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.DDManagerException;
import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.parser.XDDLanguageLexer;
import info.scce.addlib.parser.XDDLanguageParser;
import info.scce.addlib.parser.XDDVisitor;
import java.util.NoSuchElementException;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class XDDManager<T>
extends DDManager<XDD<T>, ADDBackend> {
    private final BiMap<T, Double> valueMap = HashBiMap.create();
    private double nextValueId = 0.0;

    public XDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public XDDManager(ADDBackend backend) {
        super(backend);
    }

    public XDD<T> constant(T value) {
        long resultPtr = ((ADDBackend)this.getBackend()).constant(this.ptr, this.valueId(value));
        return (XDD)new XDD(resultPtr, this).withRef();
    }

    public XDD<T> neutral() {
        return this.constant(this.neutralElement());
    }

    public XDD<T> bot() {
        return this.constant(this.botElement());
    }

    public XDD<T> top() {
        return this.constant(this.topElement());
    }

    public XDD<T> zero() {
        return this.constant(this.zeroElement());
    }

    public XDD<T> one() {
        return this.constant(this.oneElement());
    }

    @Override
    public XDD<T> namedVar(String name) {
        int i = this.varIdx(name);
        return this.ithVar(i, this.oneElement(), this.zeroElement());
    }

    public XDD<T> namedVar(String name, XDD<T> t, XDD<T> e) {
        return this.ithVar(this.varIdx(name), (T)t, (T)e);
    }

    public XDD<T> namedVar(String name, T t, T e) {
        return this.ithVar(this.varIdx(name), t, e);
    }

    public XDD<T> namedIthVar(String name, int i, T t, T e) {
        this.addVarName(name, i);
        return this.ithVar(i, t, e);
    }

    public XDD<T> namedIthVar(String name, int i, XDD<T> t, XDD<T> e) {
        this.addVarName(name, i);
        return this.ithVar(i, (T)t, (T)e);
    }

    @Override
    public XDD<T> ithVar(int i) {
        return this.ithVar(i, this.oneElement(), this.zeroElement());
    }

    public XDD<T> ithVar(int i, XDD<T> t, XDD<T> e) {
        this.varName(i);
        long varPtr = ((ADDBackend)this.getBackend()).xddIthVar(this.ptr(), i);
        return this.varFromUnreferencedAddVarPtr(varPtr, t, e);
    }

    public XDD<T> ithVar(int i, T t, T e) {
        this.varName(i);
        long varPtr = ((ADDBackend)this.getBackend()).xddIthVar(this.ptr(), i);
        return this.varFromUnreferencedAddVarPtr(varPtr, t, e);
    }

    public XDD<T> newVar() {
        return this.newVar(this.oneElement(), this.zeroElement());
    }

    public XDD<T> newVar(XDD<T> t, XDD<T> e) {
        long varPtr = ((ADDBackend)this.getBackend()).newVar(this.ptr());
        XDD<T> result = this.varFromUnreferencedAddVarPtr(varPtr, t, e);
        this.createVariableName(result);
        return result;
    }

    public XDD<T> newVar(T t, T e) {
        long varPtr = ((ADDBackend)this.getBackend()).newVar(this.ptr());
        XDD<T> result = this.varFromUnreferencedAddVarPtr(varPtr, t, e);
        this.createVariableName(result);
        return result;
    }

    public XDD<T> newVarAtLevel(int level) {
        return this.newVarAtLevel(level, this.oneElement(), this.zeroElement());
    }

    public XDD<T> newVarAtLevel(int level, XDD<T> t, XDD<T> e) {
        long varPtr = ((ADDBackend)this.getBackend()).newVarAtLevel(this.ptr(), level);
        XDD<T> result = this.varFromUnreferencedAddVarPtr(varPtr, t, e);
        this.createVariableName(result);
        return result;
    }

    public XDD<T> newVarAtLevel(int level, T t, T e) {
        long varPtr = ((ADDBackend)this.getBackend()).newVarAtLevel(this.ptr(), level);
        XDD<T> result = this.varFromUnreferencedAddVarPtr(varPtr, t, e);
        this.createVariableName(result);
        return result;
    }

    private XDD<T> varFromUnreferencedAddVarPtr(long unreferencedAddVarPtr, T v1, T v0) {
        ((ADDBackend)this.getBackend()).ref(unreferencedAddVarPtr);
        long addVarPtr = unreferencedAddVarPtr;
        XDD<T> t = this.constant(v1);
        XDD<T> e = this.constant(v0);
        long resultPtr = ((ADDBackend)this.getBackend()).ite(this.ptr(), addVarPtr, t.ptr(), e.ptr());
        XDD result = (XDD)new XDD(resultPtr, this).withRef();
        ((ADDBackend)this.backend).deref(this.ptr(), addVarPtr);
        t.recursiveDeref();
        e.recursiveDeref();
        return result;
    }

    private XDD<T> varFromUnreferencedAddVarPtr(long unreferencedAddVarPtr, XDD<T> t, XDD<T> e) {
        ((ADDBackend)this.backend).ref(unreferencedAddVarPtr);
        long addVarPtr = unreferencedAddVarPtr;
        long resultPtr = ((ADDBackend)this.getBackend()).ite(this.ptr(), addVarPtr, t.ptr(), e.ptr());
        XDD result = (XDD)new XDD(resultPtr, this).withRef();
        ((ADDBackend)this.backend).deref(this.ptr(), addVarPtr);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull T v(double valueId) {
        Object value = this.valueMap.inverse().get(valueId);
        if (value != null) {
            return (T)value;
        }
        XDDManager xDDManager = this;
        synchronized (xDDManager) {
            value = this.valueMap.inverse().get(valueId);
        }
        if (value == null) {
            throw new NoSuchElementException(String.format("The method assumes that the key '%f' is already in the map!", valueId));
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double valueId(T element) {
        XDDManager xDDManager = this;
        synchronized (xDDManager) {
            Double value = (Double)this.valueMap.get(element);
            if (value == null) {
                double d = this.nextValueId;
                this.nextValueId = d + 1.0;
                value = d;
                this.valueMap.put(element, value);
            }
            return value;
        }
    }

    protected T neutralElement() {
        throw this.undefinedInAlgebraicStructureException("neutralElement");
    }

    protected T botElement() {
        throw this.undefinedInAlgebraicStructureException("botElement");
    }

    protected T topElement() {
        throw this.undefinedInAlgebraicStructureException("topElement");
    }

    protected T zeroElement() {
        throw this.undefinedInAlgebraicStructureException("zeroElement");
    }

    protected T oneElement() {
        throw this.undefinedInAlgebraicStructureException("oneElement");
    }

    protected T inverse(T x) {
        throw this.undefinedInAlgebraicStructureException("inverse");
    }

    protected T compl(T x) {
        throw this.undefinedInAlgebraicStructureException("compl");
    }

    protected T not(T x) {
        throw this.undefinedInAlgebraicStructureException("not");
    }

    protected T multInverse(T x) {
        throw this.undefinedInAlgebraicStructureException("multInverse");
    }

    protected T addInverse(T x) {
        throw this.undefinedInAlgebraicStructureException("addInverse");
    }

    protected T meet(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("meet");
    }

    protected T inf(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("inf");
    }

    protected T intersect(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("intersect");
    }

    protected T and(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("and");
    }

    protected T mult(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("mult");
    }

    protected T join(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("join");
    }

    protected T sup(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("sup");
    }

    protected T union(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("union");
    }

    protected T or(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("or");
    }

    protected T add(T left, T right) {
        throw this.undefinedInAlgebraicStructureException("add");
    }

    public T parseElement(String str) {
        throw this.undefinedInAlgebraicStructureException("parseElement");
    }

    protected DDManagerException undefinedInAlgebraicStructureException(String what) {
        return new DDManagerException(this.getClass().getSimpleName() + " does not define " + what);
    }

    @Override
    public XDD<T> parse(String str) {
        ANTLRInputStream inputStream = new ANTLRInputStream(str);
        XDDLanguageLexer lexer = new XDDLanguageLexer(inputStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        XDDLanguageParser parser = new XDDLanguageParser(tokens);
        XDDLanguageParser.StartContext tree = parser.start();
        XDDVisitor ast = new XDDVisitor(this);
        return (XDD)ast.visit(tree);
    }
}

