/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComplementableSet<E> {
    private final boolean compl;
    private final Set<E> explRepr;

    public ComplementableSet(E[] elements) {
        this.compl = false;
        this.explRepr = new HashSet();
        this.explRepr.addAll(Arrays.asList(elements));
    }

    private ComplementableSet(Set<E> explRepr, boolean compl) {
        this.compl = compl;
        this.explRepr = explRepr;
    }

    public static <T> ComplementableSet<T> emptySet() {
        return new ComplementableSet(new HashSet(), false);
    }

    public static <T> ComplementableSet<T> completeSet() {
        return new ComplementableSet(new HashSet(), true);
    }

    public static <T> ComplementableSet<T> parseComplementableSet(String str, Function<String, T> parseElement) {
        boolean compl = str.endsWith("^C");
        int trimEnd = compl ? 3 : 1;
        String strCommaSeparatedExplReprs = str.substring(1, str.length() - trimEnd);
        String[] strExplReprs = strCommaSeparatedExplReprs.split(", ");
        HashSet<T> explRepr = new HashSet<T>();
        for (String strExplRepr : strExplReprs) {
            if (strExplRepr.isEmpty()) continue;
            T parsed = parseElement.apply(strExplRepr);
            explRepr.add(parsed);
        }
        return new ComplementableSet(explRepr, compl);
    }

    public boolean contains(E x) {
        boolean explReprContains = this.explRepr.contains(x);
        return this.compl != explReprContains;
    }

    public Set<E> explRepr() {
        return new HashSet<E>(this.explRepr);
    }

    public boolean compl() {
        return this.compl;
    }

    public ComplementableSet<E> intersect(ComplementableSet<E> other) {
        if (this.compl) {
            if (other.compl) {
                return new ComplementableSet<E>(this.explUnion(this.explRepr, other.explRepr), true);
            }
            return new ComplementableSet<E>(this.explDiff(other.explRepr, this.explRepr), false);
        }
        if (other.compl) {
            return new ComplementableSet<E>(this.explDiff(this.explRepr, other.explRepr), false);
        }
        return new ComplementableSet<E>(this.explIntersect(this.explRepr, other.explRepr), false);
    }

    public ComplementableSet<E> union(ComplementableSet<E> other) {
        if (this.compl) {
            if (other.compl) {
                return new ComplementableSet<E>(this.explIntersect(this.explRepr, other.explRepr), true);
            }
            return new ComplementableSet<E>(this.explDiff(this.explRepr, other.explRepr), true);
        }
        if (other.compl) {
            return new ComplementableSet<E>(this.explDiff(other.explRepr, this.explRepr), true);
        }
        return new ComplementableSet<E>(this.explUnion(this.explRepr, other.explRepr), false);
    }

    private Set<E> explIntersect(Set<E> a, Set<E> b) {
        HashSet<E> s2 = new HashSet<E>(a);
        s2.retainAll(b);
        return s2;
    }

    private Set<E> explUnion(Set<E> a, Set<E> b) {
        HashSet<E> s2 = new HashSet<E>();
        s2.addAll(a);
        s2.addAll(b);
        return s2;
    }

    private Set<E> explDiff(Set<E> a, Set<E> b) {
        HashSet<E> s2 = new HashSet<E>(a);
        s2.removeAll(b);
        return s2;
    }

    public ComplementableSet<E> complement() {
        return new ComplementableSet<E>(this.explRepr, !this.compl);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplementableSet that = (ComplementableSet)o;
        return this.compl == that.compl && Objects.equals(this.explRepr, that.explRepr);
    }

    public int hashCode() {
        return Objects.hash(this.compl, this.explRepr);
    }

    public String toString() {
        String strExplRepr = this.explRepr.toString();
        String strExplReprStripped = strExplRepr.substring(1, strExplRepr.length() - 1);
        return "[" + strExplReprStripped + "]" + (this.compl ? "^C" : "");
    }
}

