/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.layouter;

import org.checkerframework.checker.nullness.qual.Nullable;

public class BoundingBox {
    private final double x;
    private final double y;
    private final double w;
    private final double h;

    public BoundingBox(double x, double y, double w, double h2) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h2;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double x2() {
        return this.x() + this.w();
    }

    public double y2() {
        return this.y() + this.h();
    }

    public double w() {
        return this.w;
    }

    public double h() {
        return this.h;
    }

    public double area() {
        return this.w * this.h;
    }

    public double overlap(BoundingBox other) {
        double overlapW = Math.max(0.0, Math.min(this.x2(), other.x2()) - Math.max(this.x, other.x));
        double overlapH = Math.max(0.0, Math.min(this.y2(), other.y2()) - Math.max(this.y, other.y));
        return overlapW * overlapH;
    }

    public boolean overlaps(BoundingBox other) {
        return this.overlap(other) > 0.0;
    }

    public boolean contains(BoundingBox other) {
        return this.x <= other.x && this.y <= other.y && other.x2() <= this.x2() && other.y2() <= this.y2();
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj instanceof BoundingBox) {
            BoundingBox other = (BoundingBox)otherObj;
            return this.x == other.x && this.y == other.y && this.w == other.w && this.h == other.h;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.w) + Double.hashCode(this.h);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.w + ", " + this.h + ")";
    }
}

