/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.parser;

import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.dd.bdd.BDDManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class CnfParser {
    public BDD parseCnf(BDDManager manager, String str) {
        try (StringReader sr = new StringReader(str);){
            Scanner sc = new Scanner(sr);
            try {
                BDD bDD = this.parseCnf(manager, sc);
                sc.close();
                return bDD;
            }
            catch (Throwable throwable) {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public BDD parseCnf(BDDManager manager, File file) throws FileNotFoundException {
        return this.parseCnf(manager, file, StandardCharsets.UTF_8);
    }

    public BDD parseCnf(BDDManager manager, File file, Charset cs) throws FileNotFoundException {
        try (Scanner sc = new Scanner(file, cs.name());){
            BDD bDD = this.parseCnf(manager, sc);
            return bDD;
        }
    }

    public BDD parseCnf(BDDManager manager, InputStream in) {
        return this.parseCnf(manager, in, StandardCharsets.UTF_8);
    }

    public BDD parseCnf(BDDManager manager, InputStream in, Charset cs) {
        Scanner sc = new Scanner(in, cs.name());
        return this.parseCnf(manager, sc);
    }

    private BDD parseCnf(BDDManager manager, Scanner sc) {
        BDD ret = manager.readOne();
        while (sc.hasNextLine()) {
            String[] vars;
            String current = sc.nextLine();
            if (current.startsWith("c") || current.startsWith("p")) continue;
            if (current.startsWith("%")) break;
            BDD clause = manager.readLogicZero();
            for (String var : vars = current.split(" ")) {
                BDD lit;
                if ("0".equals(var)) break;
                if ("".equals(var)) continue;
                if (var.startsWith("-")) {
                    lit = manager.ithVar(Integer.parseInt(var.substring(1)));
                    BDD newlit = lit.not();
                    lit.recursiveDeref();
                    lit = newlit;
                } else {
                    lit = manager.ithVar(Integer.parseInt(var));
                }
                BDD newclause = clause.or(lit);
                clause.recursiveDeref();
                clause = newclause;
                lit.recursiveDeref();
            }
            BDD newret = ret.and(clause);
            ret.recursiveDeref();
            ret = newret;
            clause.recursiveDeref();
        }
        return ret;
    }
}

