/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.parser;

import info.scce.addlib.dd.zdd.ZDD;
import info.scce.addlib.dd.zdd.ZDDManager;
import info.scce.addlib.parser.ZDDLanguageBaseVisitor;
import info.scce.addlib.parser.ZDDLanguageParser;

public class ZDDVisitor
extends ZDDLanguageBaseVisitor<ZDD> {
    private final ZDDManager ddManager;

    public ZDDVisitor(ZDDManager ddManager) {
        this.ddManager = ddManager;
    }

    @Override
    public ZDD visitStart(ZDDLanguageParser.StartContext ctx) {
        return (ZDD)this.visit(ctx.ex);
    }

    @Override
    public ZDD visitVarExpr(ZDDLanguageParser.VarExprContext ctx) {
        String varName = ctx.var.getText();
        return this.ddManager.namedVar(varName);
    }

    @Override
    public ZDD visitZddOneExpr(ZDDLanguageParser.ZddOneExprContext ctx) {
        int i = Integer.parseInt(ctx.i.getText());
        return this.ddManager.readZddOne(i);
    }

    @Override
    public ZDD visitNotExpr(ZDDLanguageParser.NotExprContext ctx) {
        ZDD left = (ZDD)this.visit(ctx.left);
        ZDD right = (ZDD)this.visit(ctx.right);
        ZDD result = left.diff(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public ZDD visitAtomExpr(ZDDLanguageParser.AtomExprContext ctx) {
        return (ZDD)this.visit(ctx.ap);
    }

    @Override
    public ZDD visitChangeExpr(ZDDLanguageParser.ChangeExprContext ctx) {
        ZDD child = (ZDD)this.visit(ctx.ex);
        int var = Integer.parseInt(ctx.v.getText());
        ZDD result = child.change(var);
        child.recursiveDeref();
        return result;
    }

    @Override
    public ZDD visitOrExpr(ZDDLanguageParser.OrExprContext ctx) {
        ZDD left = (ZDD)this.visit(ctx.left);
        ZDD right = (ZDD)this.visit(ctx.right);
        ZDD result = left.union(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public ZDD visitParenExpr(ZDDLanguageParser.ParenExprContext ctx) {
        return (ZDD)this.visit(ctx.ex);
    }

    @Override
    public ZDD visitAndExpr(ZDDLanguageParser.AndExprContext ctx) {
        ZDD left = (ZDD)this.visit(ctx.left);
        ZDD right = (ZDD)this.visit(ctx.right);
        ZDD result = left.intersect(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public ZDD visitTrueExpr(ZDDLanguageParser.TrueExprContext ctx) {
        return this.ddManager.readOne();
    }

    @Override
    public ZDD visitFalseExpr(ZDDLanguageParser.FalseExprContext ctx) {
        return this.ddManager.readZero();
    }
}

